/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyCollectionRequest;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyCollectionRequest;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMultiValueLegacyExtendedPropertyCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMultiValueLegacyExtendedPropertyCollectionRequest;
import java.util.List;

public class BaseMultiValueLegacyExtendedPropertyCollectionRequest
extends BaseCollectionRequest<BaseMultiValueLegacyExtendedPropertyCollectionResponse, IMultiValueLegacyExtendedPropertyCollectionPage>
implements IBaseMultiValueLegacyExtendedPropertyCollectionRequest {
    public BaseMultiValueLegacyExtendedPropertyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMultiValueLegacyExtendedPropertyCollectionResponse.class, IMultiValueLegacyExtendedPropertyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMultiValueLegacyExtendedPropertyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMultiValueLegacyExtendedPropertyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMultiValueLegacyExtendedPropertyCollectionPage get() throws ClientException {
        BaseMultiValueLegacyExtendedPropertyCollectionResponse response = (BaseMultiValueLegacyExtendedPropertyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty, ICallback<MultiValueLegacyExtendedProperty> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MultiValueLegacyExtendedPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMultiValueLegacyExtendedProperty, callback);
    }

    @Override
    public MultiValueLegacyExtendedProperty post(MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MultiValueLegacyExtendedPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMultiValueLegacyExtendedProperty);
    }

    @Override
    public IMultiValueLegacyExtendedPropertyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    @Override
    public IMultiValueLegacyExtendedPropertyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    @Override
    public IMultiValueLegacyExtendedPropertyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    public IMultiValueLegacyExtendedPropertyCollectionPage buildFromResponse(BaseMultiValueLegacyExtendedPropertyCollectionResponse response) {
        MultiValueLegacyExtendedPropertyCollectionRequestBuilder builder = response.nextLink != null ? new MultiValueLegacyExtendedPropertyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MultiValueLegacyExtendedPropertyCollectionPage page = new MultiValueLegacyExtendedPropertyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

