/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppContentFile;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppContentFileCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppContentFileCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentFileRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileAppContentFileCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileAppContentFileCollectionRequest;
import java.util.List;

public class BaseMobileAppContentFileCollectionRequest
extends BaseCollectionRequest<BaseMobileAppContentFileCollectionResponse, IMobileAppContentFileCollectionPage>
implements IBaseMobileAppContentFileCollectionRequest {
    public BaseMobileAppContentFileCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileAppContentFileCollectionResponse.class, IMobileAppContentFileCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppContentFileCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMobileAppContentFileCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppContentFileCollectionPage get() throws ClientException {
        BaseMobileAppContentFileCollectionResponse response = (BaseMobileAppContentFileCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppContentFile newMobileAppContentFile, ICallback<MobileAppContentFile> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContentFile, callback);
    }

    @Override
    public MobileAppContentFile post(MobileAppContentFile newMobileAppContentFile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContentFile);
    }

    @Override
    public IMobileAppContentFileCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileAppContentFileCollectionRequest)this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileAppContentFileCollectionRequest)this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppContentFileCollectionRequest)this;
    }

    public IMobileAppContentFileCollectionPage buildFromResponse(BaseMobileAppContentFileCollectionResponse response) {
        MobileAppContentFileCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppContentFileCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppContentFileCollectionPage page = new MobileAppContentFileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

