/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedAppRegistrationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedAppRegistrationCollectionRequest;
import java.util.List;

public class BaseManagedAppRegistrationCollectionRequest
extends BaseCollectionRequest<BaseManagedAppRegistrationCollectionResponse, IManagedAppRegistrationCollectionPage>
implements IBaseManagedAppRegistrationCollectionRequest {
    public BaseManagedAppRegistrationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedAppRegistrationCollectionResponse.class, IManagedAppRegistrationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppRegistrationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedAppRegistrationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppRegistrationCollectionPage get() throws ClientException {
        BaseManagedAppRegistrationCollectionResponse response = (BaseManagedAppRegistrationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppRegistration newManagedAppRegistration, ICallback<ManagedAppRegistration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration, callback);
    }

    @Override
    public ManagedAppRegistration post(ManagedAppRegistration newManagedAppRegistration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppRegistrationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppRegistration);
    }

    @Override
    public IManagedAppRegistrationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedAppRegistrationCollectionRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedAppRegistrationCollectionRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedAppRegistrationCollectionRequest)this;
    }

    public IManagedAppRegistrationCollectionPage buildFromResponse(BaseManagedAppRegistrationCollectionResponse response) {
        ManagedAppRegistrationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppRegistrationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppRegistrationCollectionPage page = new ManagedAppRegistrationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

