/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppOperationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedAppOperationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedAppOperationCollectionRequest;
import java.util.List;

public class BaseManagedAppOperationCollectionRequest
extends BaseCollectionRequest<BaseManagedAppOperationCollectionResponse, IManagedAppOperationCollectionPage>
implements IBaseManagedAppOperationCollectionRequest {
    public BaseManagedAppOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedAppOperationCollectionResponse.class, IManagedAppOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedAppOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppOperationCollectionPage get() throws ClientException {
        BaseManagedAppOperationCollectionResponse response = (BaseManagedAppOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppOperation newManagedAppOperation, ICallback<ManagedAppOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppOperation, callback);
    }

    @Override
    public ManagedAppOperation post(ManagedAppOperation newManagedAppOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedAppOperation);
    }

    @Override
    public IManagedAppOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedAppOperationCollectionRequest)this;
    }

    @Override
    public IManagedAppOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedAppOperationCollectionRequest)this;
    }

    @Override
    public IManagedAppOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedAppOperationCollectionRequest)this;
    }

    public IManagedAppOperationCollectionPage buildFromResponse(BaseManagedAppOperationCollectionResponse response) {
        ManagedAppOperationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppOperationCollectionPage page = new ManagedAppOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

