/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceInstallState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceInstallStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceInstallStateCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceInstallStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceInstallStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceInstallStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceInstallStateCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceInstallStateCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceInstallStateCollectionRequest;
import java.util.List;

public class BaseDeviceInstallStateCollectionRequest
extends BaseCollectionRequest<BaseDeviceInstallStateCollectionResponse, IDeviceInstallStateCollectionPage>
implements IBaseDeviceInstallStateCollectionRequest {
    public BaseDeviceInstallStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceInstallStateCollectionResponse.class, IDeviceInstallStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceInstallStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceInstallStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceInstallStateCollectionPage get() throws ClientException {
        BaseDeviceInstallStateCollectionResponse response = (BaseDeviceInstallStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceInstallState newDeviceInstallState, ICallback<DeviceInstallState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceInstallStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceInstallState, callback);
    }

    @Override
    public DeviceInstallState post(DeviceInstallState newDeviceInstallState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceInstallStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceInstallState);
    }

    @Override
    public IDeviceInstallStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceInstallStateCollectionRequest)this;
    }

    @Override
    public IDeviceInstallStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceInstallStateCollectionRequest)this;
    }

    @Override
    public IDeviceInstallStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceInstallStateCollectionRequest)this;
    }

    public IDeviceInstallStateCollectionPage buildFromResponse(BaseDeviceInstallStateCollectionResponse response) {
        DeviceInstallStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceInstallStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceInstallStateCollectionPage page = new DeviceInstallStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

