/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceAndAppManagementRoleAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceAndAppManagementRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceAndAppManagementRoleAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceAndAppManagementRoleAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceAndAppManagementRoleAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceAndAppManagementRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceAndAppManagementRoleAssignmentCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceAndAppManagementRoleAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceAndAppManagementRoleAssignmentCollectionRequest;
import java.util.List;

public class BaseDeviceAndAppManagementRoleAssignmentCollectionRequest
extends BaseCollectionRequest<BaseDeviceAndAppManagementRoleAssignmentCollectionResponse, IDeviceAndAppManagementRoleAssignmentCollectionPage>
implements IBaseDeviceAndAppManagementRoleAssignmentCollectionRequest {
    public BaseDeviceAndAppManagementRoleAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceAndAppManagementRoleAssignmentCollectionResponse.class, IDeviceAndAppManagementRoleAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceAndAppManagementRoleAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceAndAppManagementRoleAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceAndAppManagementRoleAssignmentCollectionPage get() throws ClientException {
        BaseDeviceAndAppManagementRoleAssignmentCollectionResponse response = (BaseDeviceAndAppManagementRoleAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceAndAppManagementRoleAssignment newDeviceAndAppManagementRoleAssignment, ICallback<DeviceAndAppManagementRoleAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceAndAppManagementRoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceAndAppManagementRoleAssignment, callback);
    }

    @Override
    public DeviceAndAppManagementRoleAssignment post(DeviceAndAppManagementRoleAssignment newDeviceAndAppManagementRoleAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceAndAppManagementRoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceAndAppManagementRoleAssignment);
    }

    @Override
    public IDeviceAndAppManagementRoleAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceAndAppManagementRoleAssignmentCollectionRequest)this;
    }

    @Override
    public IDeviceAndAppManagementRoleAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceAndAppManagementRoleAssignmentCollectionRequest)this;
    }

    @Override
    public IDeviceAndAppManagementRoleAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceAndAppManagementRoleAssignmentCollectionRequest)this;
    }

    public IDeviceAndAppManagementRoleAssignmentCollectionPage buildFromResponse(BaseDeviceAndAppManagementRoleAssignmentCollectionResponse response) {
        DeviceAndAppManagementRoleAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new DeviceAndAppManagementRoleAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceAndAppManagementRoleAssignmentCollectionPage page = new DeviceAndAppManagementRoleAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

