/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DetectedApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionPage;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionRequest;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DetectedAppRequestBuilder;
import com.microsoft.graph.requests.extensions.IDetectedAppCollectionPage;
import com.microsoft.graph.requests.extensions.IDetectedAppCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDetectedAppCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDetectedAppCollectionRequest;
import java.util.List;

public class BaseDetectedAppCollectionRequest
extends BaseCollectionRequest<BaseDetectedAppCollectionResponse, IDetectedAppCollectionPage>
implements IBaseDetectedAppCollectionRequest {
    public BaseDetectedAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDetectedAppCollectionResponse.class, IDetectedAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDetectedAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDetectedAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDetectedAppCollectionPage get() throws ClientException {
        BaseDetectedAppCollectionResponse response = (BaseDetectedAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DetectedApp newDetectedApp, ICallback<DetectedApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDetectedApp, callback);
    }

    @Override
    public DetectedApp post(DetectedApp newDetectedApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDetectedApp);
    }

    @Override
    public IDetectedAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DetectedAppCollectionRequest)this;
    }

    @Override
    public IDetectedAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DetectedAppCollectionRequest)this;
    }

    @Override
    public IDetectedAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DetectedAppCollectionRequest)this;
    }

    public IDetectedAppCollectionPage buildFromResponse(BaseDetectedAppCollectionResponse response) {
        DetectedAppCollectionRequestBuilder builder = response.nextLink != null ? new DetectedAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DetectedAppCollectionPage page = new DetectedAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

