/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AndroidManagedAppProtection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AndroidManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.AndroidManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.extensions.AndroidManagedAppProtectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AndroidManagedAppProtectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAndroidManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IAndroidManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.generated.BaseAndroidManagedAppProtectionCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseAndroidManagedAppProtectionCollectionRequest;
import java.util.List;

public class BaseAndroidManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<BaseAndroidManagedAppProtectionCollectionResponse, IAndroidManagedAppProtectionCollectionPage>
implements IBaseAndroidManagedAppProtectionCollectionRequest {
    public BaseAndroidManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseAndroidManagedAppProtectionCollectionResponse.class, IAndroidManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAndroidManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseAndroidManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAndroidManagedAppProtectionCollectionPage get() throws ClientException {
        BaseAndroidManagedAppProtectionCollectionResponse response = (BaseAndroidManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AndroidManagedAppProtection newAndroidManagedAppProtection, ICallback<AndroidManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AndroidManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newAndroidManagedAppProtection, callback);
    }

    @Override
    public AndroidManagedAppProtection post(AndroidManagedAppProtection newAndroidManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AndroidManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newAndroidManagedAppProtection);
    }

    @Override
    public IAndroidManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (AndroidManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IAndroidManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (AndroidManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IAndroidManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (AndroidManagedAppProtectionCollectionRequest)this;
    }

    public IAndroidManagedAppProtectionCollectionPage buildFromResponse(BaseAndroidManagedAppProtectionCollectionResponse response) {
        AndroidManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new AndroidManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AndroidManagedAppProtectionCollectionPage page = new AndroidManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

