/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ActivityHistoryItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionPage;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionRequest;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemCollectionPage;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemCollectionRequest;
import com.microsoft.graph.requests.generated.BaseActivityHistoryItemCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseActivityHistoryItemCollectionRequest;
import java.util.List;

public class BaseActivityHistoryItemCollectionRequest
extends BaseCollectionRequest<BaseActivityHistoryItemCollectionResponse, IActivityHistoryItemCollectionPage>
implements IBaseActivityHistoryItemCollectionRequest {
    public BaseActivityHistoryItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseActivityHistoryItemCollectionResponse.class, IActivityHistoryItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IActivityHistoryItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseActivityHistoryItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IActivityHistoryItemCollectionPage get() throws ClientException {
        BaseActivityHistoryItemCollectionResponse response = (BaseActivityHistoryItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ActivityHistoryItem newActivityHistoryItem, ICallback<ActivityHistoryItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newActivityHistoryItem, callback);
    }

    @Override
    public ActivityHistoryItem post(ActivityHistoryItem newActivityHistoryItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newActivityHistoryItem);
    }

    @Override
    public IActivityHistoryItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ActivityHistoryItemCollectionRequest)this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ActivityHistoryItemCollectionRequest)this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ActivityHistoryItemCollectionRequest)this;
    }

    public IActivityHistoryItemCollectionPage buildFromResponse(BaseActivityHistoryItemCollectionResponse response) {
        ActivityHistoryItemCollectionRequestBuilder builder = response.nextLink != null ? new ActivityHistoryItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ActivityHistoryItemCollectionPage page = new ActivityHistoryItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

