/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.UserGetMailTipsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserGetMailTipsCollectionPage;
import com.microsoft.graph.requests.extensions.IUserGetMailTipsCollectionRequest;
import com.microsoft.graph.requests.extensions.UserGetMailTipsCollectionPage;
import com.microsoft.graph.requests.extensions.UserGetMailTipsCollectionRequestBuilder;
import com.microsoft.graph.requests.generated.BaseUserGetMailTipsCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseUserGetMailTipsCollectionRequest;
import java.util.List;

public class BaseUserGetMailTipsCollectionRequest
extends BaseCollectionRequest<BaseUserGetMailTipsCollectionResponse, IUserGetMailTipsCollectionPage>
implements IBaseUserGetMailTipsCollectionRequest {
    protected final UserGetMailTipsBody body = new UserGetMailTipsBody();

    public BaseUserGetMailTipsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseUserGetMailTipsCollectionResponse.class, IUserGetMailTipsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IUserGetMailTipsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseUserGetMailTipsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserGetMailTipsCollectionPage post() throws ClientException {
        BaseUserGetMailTipsCollectionResponse response = (BaseUserGetMailTipsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IUserGetMailTipsCollectionPage buildFromResponse(BaseUserGetMailTipsCollectionResponse response) {
        UserGetMailTipsCollectionRequestBuilder builder = response.nextLink != null ? new UserGetMailTipsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null) : null;
        UserGetMailTipsCollectionPage page = new UserGetMailTipsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IUserGetMailTipsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IUserGetMailTipsCollectionRequest)((Object)this);
    }

    @Override
    public IUserGetMailTipsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IUserGetMailTipsCollectionRequest)((Object)this);
    }

    @Override
    public IUserGetMailTipsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IUserGetMailTipsCollectionRequest)((Object)this);
    }
}

