/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DriveItemPreviewBody;
import com.microsoft.graph.models.extensions.ItemPreviewInfo;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemPreviewRequest;
import com.microsoft.graph.requests.extensions.IDriveItemPreviewRequest;
import com.microsoft.graph.requests.generated.IBaseDriveItemPreviewRequest;
import java.util.List;

public class BaseDriveItemPreviewRequest
extends BaseRequest
implements IBaseDriveItemPreviewRequest {
    protected final DriveItemPreviewBody body = new DriveItemPreviewBody();

    public BaseDriveItemPreviewRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemPreviewInfo.class);
    }

    @Override
    public void post(ICallback<ItemPreviewInfo> callback) {
        this.send(HttpMethod.POST, callback, this.body);
    }

    @Override
    public ItemPreviewInfo post() throws ClientException {
        return (ItemPreviewInfo)this.send(HttpMethod.POST, this.body);
    }

    @Override
    public IDriveItemPreviewRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (DriveItemPreviewRequest)this;
    }

    @Override
    public IDriveItemPreviewRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("$top", value + ""));
        return (DriveItemPreviewRequest)this;
    }

    @Override
    public IDriveItemPreviewRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (DriveItemPreviewRequest)this;
    }
}

