/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObjectGetByIdsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetByIdsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetByIdsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetByIdsCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetByIdsCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDirectoryObjectGetByIdsCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDirectoryObjectGetByIdsCollectionRequest;
import java.util.List;

public class BaseDirectoryObjectGetByIdsCollectionRequest
extends BaseCollectionRequest<BaseDirectoryObjectGetByIdsCollectionResponse, IDirectoryObjectGetByIdsCollectionPage>
implements IBaseDirectoryObjectGetByIdsCollectionRequest {
    protected final DirectoryObjectGetByIdsBody body = new DirectoryObjectGetByIdsBody();

    public BaseDirectoryObjectGetByIdsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDirectoryObjectGetByIdsCollectionResponse.class, IDirectoryObjectGetByIdsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IDirectoryObjectGetByIdsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDirectoryObjectGetByIdsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionPage post() throws ClientException {
        BaseDirectoryObjectGetByIdsCollectionResponse response = (BaseDirectoryObjectGetByIdsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectGetByIdsCollectionPage buildFromResponse(BaseDirectoryObjectGetByIdsCollectionResponse response) {
        DirectoryObjectGetByIdsCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectGetByIdsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null) : null;
        DirectoryObjectGetByIdsCollectionPage page = new DirectoryObjectGetByIdsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDirectoryObjectGetByIdsCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDirectoryObjectGetByIdsCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryObjectGetByIdsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDirectoryObjectGetByIdsCollectionRequest)((Object)this);
    }
}

