/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceCompliancePolicyAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceCompliancePolicyAssignmentCollectionRequest;
import java.util.List;

public class BaseDeviceCompliancePolicyAssignmentCollectionRequest
extends BaseCollectionRequest<BaseDeviceCompliancePolicyAssignmentCollectionResponse, IDeviceCompliancePolicyAssignmentCollectionPage>
implements IBaseDeviceCompliancePolicyAssignmentCollectionRequest {
    public BaseDeviceCompliancePolicyAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceCompliancePolicyAssignmentCollectionResponse.class, IDeviceCompliancePolicyAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCompliancePolicyAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceCompliancePolicyAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionPage get() throws ClientException {
        BaseDeviceCompliancePolicyAssignmentCollectionResponse response = (BaseDeviceCompliancePolicyAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCompliancePolicyAssignment newDeviceCompliancePolicyAssignment, ICallback<DeviceCompliancePolicyAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCompliancePolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicyAssignment, callback);
    }

    @Override
    public DeviceCompliancePolicyAssignment post(DeviceCompliancePolicyAssignment newDeviceCompliancePolicyAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCompliancePolicyAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicyAssignment);
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceCompliancePolicyAssignmentCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceCompliancePolicyAssignmentCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceCompliancePolicyAssignmentCollectionRequest)this;
    }

    public IDeviceCompliancePolicyAssignmentCollectionPage buildFromResponse(BaseDeviceCompliancePolicyAssignmentCollectionResponse response) {
        DeviceCompliancePolicyAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCompliancePolicyAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCompliancePolicyAssignmentCollectionPage page = new DeviceCompliancePolicyAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

