/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PlannerBucket;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlannerBucketCollectionPage;
import com.microsoft.graph.requests.extensions.IPlannerBucketCollectionRequest;
import com.microsoft.graph.requests.extensions.PlannerBucketCollectionPage;
import com.microsoft.graph.requests.extensions.PlannerBucketCollectionRequest;
import com.microsoft.graph.requests.extensions.PlannerBucketCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PlannerBucketRequestBuilder;
import com.microsoft.graph.requests.generated.BasePlannerBucketCollectionResponse;
import com.microsoft.graph.requests.generated.IBasePlannerBucketCollectionRequest;
import java.util.List;

public class BasePlannerBucketCollectionRequest
extends BaseCollectionRequest<BasePlannerBucketCollectionResponse, IPlannerBucketCollectionPage>
implements IBasePlannerBucketCollectionRequest {
    public BasePlannerBucketCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BasePlannerBucketCollectionResponse.class, IPlannerBucketCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerBucketCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePlannerBucketCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerBucketCollectionPage get() throws ClientException {
        BasePlannerBucketCollectionResponse response = (BasePlannerBucketCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerBucket newPlannerBucket, ICallback<PlannerBucket> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerBucketRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerBucket, callback);
    }

    @Override
    public PlannerBucket post(PlannerBucket newPlannerBucket) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerBucketRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerBucket);
    }

    @Override
    public IPlannerBucketCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (PlannerBucketCollectionRequest)this;
    }

    @Override
    public IPlannerBucketCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (PlannerBucketCollectionRequest)this;
    }

    @Override
    public IPlannerBucketCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (PlannerBucketCollectionRequest)this;
    }

    public IPlannerBucketCollectionPage buildFromResponse(BasePlannerBucketCollectionResponse response) {
        PlannerBucketCollectionRequestBuilder builder = response.nextLink != null ? new PlannerBucketCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerBucketCollectionPage page = new PlannerBucketCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

