/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedEBookAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedEBookAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedEBookAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedEBookAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedEBookAssignmentCollectionRequest;
import java.util.List;

public class BaseManagedEBookAssignmentCollectionRequest
extends BaseCollectionRequest<BaseManagedEBookAssignmentCollectionResponse, IManagedEBookAssignmentCollectionPage>
implements IBaseManagedEBookAssignmentCollectionRequest {
    public BaseManagedEBookAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedEBookAssignmentCollectionResponse.class, IManagedEBookAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedEBookAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedEBookAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedEBookAssignmentCollectionPage get() throws ClientException {
        BaseManagedEBookAssignmentCollectionResponse response = (BaseManagedEBookAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedEBookAssignment newManagedEBookAssignment, ICallback<ManagedEBookAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedEBookAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedEBookAssignment, callback);
    }

    @Override
    public ManagedEBookAssignment post(ManagedEBookAssignment newManagedEBookAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedEBookAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedEBookAssignment);
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedEBookAssignmentCollectionRequest)this;
    }

    public IManagedEBookAssignmentCollectionPage buildFromResponse(BaseManagedEBookAssignmentCollectionResponse response) {
        ManagedEBookAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new ManagedEBookAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedEBookAssignmentCollectionPage page = new ManagedEBookAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

