/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemRequest;
import com.microsoft.graph.requests.extensions.IDriveItemRequest;
import com.microsoft.graph.requests.generated.IBaseDriveItemRequest;
import java.util.List;

public class BaseDriveItemRequest
extends BaseRequest
implements IBaseDriveItemRequest {
    public BaseDriveItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<DriveItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Override
    public void get(ICallback<DriveItem> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DriveItem get() throws ClientException {
        return (DriveItem)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DriveItem> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DriveItem sourceDriveItem, ICallback<DriveItem> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDriveItem);
    }

    @Override
    public DriveItem patch(DriveItem sourceDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.PATCH, sourceDriveItem);
    }

    @Override
    public void post(DriveItem newDriveItem, ICallback<DriveItem> callback) {
        this.send(HttpMethod.POST, callback, newDriveItem);
    }

    @Override
    public DriveItem post(DriveItem newDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.POST, newDriveItem);
    }

    @Override
    public IDriveItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (DriveItemRequest)this;
    }

    @Override
    public IDriveItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (DriveItemRequest)this;
    }
}

