package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class EducationSubmissionResource extends Entity implements Parsable {
    /**
     * Instantiates a new {@link EducationSubmissionResource} and sets the default values.
     */
    public EducationSubmissionResource() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link EducationSubmissionResource}
     */
    @jakarta.annotation.Nonnull
    public static EducationSubmissionResource createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationSubmissionResource();
    }
    /**
     * Gets the assignmentResourceUrl property value. Pointer to the assignment from which the resource was copied. If the value is null, the student uploaded the resource.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getAssignmentResourceUrl() {
        return this.backingStore.get("assignmentResourceUrl");
    }
    /**
     * Gets the dependentResources property value. The dependentResources property
     * @return a {@link java.util.List<EducationSubmissionResource>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<EducationSubmissionResource> getDependentResources() {
        return this.backingStore.get("dependentResources");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignmentResourceUrl", (n) -> { this.setAssignmentResourceUrl(n.getStringValue()); });
        deserializerMap.put("dependentResources", (n) -> { this.setDependentResources(n.getCollectionOfObjectValues(EducationSubmissionResource::createFromDiscriminatorValue)); });
        deserializerMap.put("resource", (n) -> { this.setResource(n.getObjectValue(EducationResource::createFromDiscriminatorValue)); });
        return deserializerMap;
    }
    /**
     * Gets the resource property value. Resource object.
     * @return a {@link EducationResource}
     */
    @jakarta.annotation.Nullable
    public EducationResource getResource() {
        return this.backingStore.get("resource");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("assignmentResourceUrl", this.getAssignmentResourceUrl());
        writer.writeCollectionOfObjectValues("dependentResources", this.getDependentResources());
        writer.writeObjectValue("resource", this.getResource());
    }
    /**
     * Sets the assignmentResourceUrl property value. Pointer to the assignment from which the resource was copied. If the value is null, the student uploaded the resource.
     * @param value Value to set for the assignmentResourceUrl property.
     */
    public void setAssignmentResourceUrl(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("assignmentResourceUrl", value);
    }
    /**
     * Sets the dependentResources property value. The dependentResources property
     * @param value Value to set for the dependentResources property.
     */
    public void setDependentResources(@jakarta.annotation.Nullable final java.util.List<EducationSubmissionResource> value) {
        this.backingStore.set("dependentResources", value);
    }
    /**
     * Sets the resource property value. Resource object.
     * @param value Value to set for the resource property.
     */
    public void setResource(@jakarta.annotation.Nullable final EducationResource value) {
        this.backingStore.set("resource", value);
    }
}
