package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class TeamsTab extends Entity implements Parsable {
    /**
     * Instantiates a new {@link TeamsTab} and sets the default values.
     */
    public TeamsTab() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link TeamsTab}
     */
    @jakarta.annotation.Nonnull
    public static TeamsTab createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TeamsTab();
    }
    /**
     * Gets the configuration property value. Container for custom settings applied to a tab. The tab is considered configured only once this property is set.
     * @return a {@link TeamsTabConfiguration}
     */
    @jakarta.annotation.Nullable
    public TeamsTabConfiguration getConfiguration() {
        return this.backingStore.get("configuration");
    }
    /**
     * Gets the displayName property value. Name of the tab.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getDisplayName() {
        return this.backingStore.get("displayName");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("configuration", (n) -> { this.setConfiguration(n.getObjectValue(TeamsTabConfiguration::createFromDiscriminatorValue)); });
        deserializerMap.put("displayName", (n) -> { this.setDisplayName(n.getStringValue()); });
        deserializerMap.put("messageId", (n) -> { this.setMessageId(n.getStringValue()); });
        deserializerMap.put("sortOrderIndex", (n) -> { this.setSortOrderIndex(n.getStringValue()); });
        deserializerMap.put("teamsApp", (n) -> { this.setTeamsApp(n.getObjectValue(TeamsApp::createFromDiscriminatorValue)); });
        deserializerMap.put("teamsAppId", (n) -> { this.setTeamsAppId(n.getStringValue()); });
        deserializerMap.put("webUrl", (n) -> { this.setWebUrl(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the messageId property value. The messageId property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMessageId() {
        return this.backingStore.get("messageId");
    }
    /**
     * Gets the sortOrderIndex property value. Index of the order used for sorting tabs.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getSortOrderIndex() {
        return this.backingStore.get("sortOrderIndex");
    }
    /**
     * Gets the teamsApp property value. The application that is linked to the tab.
     * @return a {@link TeamsApp}
     */
    @jakarta.annotation.Nullable
    public TeamsApp getTeamsApp() {
        return this.backingStore.get("teamsApp");
    }
    /**
     * Gets the teamsAppId property value. App definition identifier of the tab. This value can&apos;t be changed after tab creation. Because this property is deprecated, we recommend expanding teamsApp to retrieve the application that is linked to the tab.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getTeamsAppId() {
        return this.backingStore.get("teamsAppId");
    }
    /**
     * Gets the webUrl property value. Deep link URL of the tab instance. Read only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getWebUrl() {
        return this.backingStore.get("webUrl");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("configuration", this.getConfiguration());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("messageId", this.getMessageId());
        writer.writeStringValue("sortOrderIndex", this.getSortOrderIndex());
        writer.writeObjectValue("teamsApp", this.getTeamsApp());
        writer.writeStringValue("teamsAppId", this.getTeamsAppId());
        writer.writeStringValue("webUrl", this.getWebUrl());
    }
    /**
     * Sets the configuration property value. Container for custom settings applied to a tab. The tab is considered configured only once this property is set.
     * @param value Value to set for the configuration property.
     */
    public void setConfiguration(@jakarta.annotation.Nullable final TeamsTabConfiguration value) {
        this.backingStore.set("configuration", value);
    }
    /**
     * Sets the displayName property value. Name of the tab.
     * @param value Value to set for the displayName property.
     */
    public void setDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("displayName", value);
    }
    /**
     * Sets the messageId property value. The messageId property
     * @param value Value to set for the messageId property.
     */
    public void setMessageId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("messageId", value);
    }
    /**
     * Sets the sortOrderIndex property value. Index of the order used for sorting tabs.
     * @param value Value to set for the sortOrderIndex property.
     */
    public void setSortOrderIndex(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("sortOrderIndex", value);
    }
    /**
     * Sets the teamsApp property value. The application that is linked to the tab.
     * @param value Value to set for the teamsApp property.
     */
    public void setTeamsApp(@jakarta.annotation.Nullable final TeamsApp value) {
        this.backingStore.set("teamsApp", value);
    }
    /**
     * Sets the teamsAppId property value. App definition identifier of the tab. This value can&apos;t be changed after tab creation. Because this property is deprecated, we recommend expanding teamsApp to retrieve the application that is linked to the tab.
     * @param value Value to set for the teamsAppId property.
     */
    public void setTeamsAppId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("teamsAppId", value);
    }
    /**
     * Sets the webUrl property value. Deep link URL of the tab instance. Read only.
     * @param value Value to set for the webUrl property.
     */
    public void setWebUrl(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("webUrl", value);
    }
}
