package com.microsoft.graph.beta.models.healthmonitoring;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class Enrichment implements AdditionalDataHolder, BackedModel, Parsable {
    /**
     * Stores model information.
     */
    @jakarta.annotation.Nonnull
    protected BackingStore backingStore;
    /**
     * Instantiates a new {@link Enrichment} and sets the default values.
     */
    public Enrichment() {
        this.backingStore = BackingStoreFactorySingleton.instance.createBackingStore();
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link Enrichment}
     */
    @jakarta.annotation.Nonnull
    public static Enrichment createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Enrichment();
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a {@link Map<String, Object>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        Map<String, Object> value = this.backingStore.get("additionalData");
        if(value == null) {
            value = new HashMap<>();
            this.setAdditionalData(value);
        }
        return value;
    }
    /**
     * Gets the backingStore property value. Stores model information.
     * @return a {@link BackingStore}
     */
    @jakarta.annotation.Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(4);
        deserializerMap.put("impacts", (n) -> { this.setImpacts(n.getCollectionOfObjectValues(ResourceImpactSummary::createFromDiscriminatorValue)); });
        deserializerMap.put("@odata.type", (n) -> { this.setOdataType(n.getStringValue()); });
        deserializerMap.put("state", (n) -> { this.setState(n.getEnumValue(EnrichmentState::forValue)); });
        deserializerMap.put("supportingData", (n) -> { this.setSupportingData(n.getObjectValue(SupportingData::createFromDiscriminatorValue)); });
        return deserializerMap;
    }
    /**
     * Gets the impacts property value. A collection of resource impact summaries that gives a high level view of the kind of resources that were impacted and to what degree.
     * @return a {@link java.util.List<ResourceImpactSummary>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<ResourceImpactSummary> getImpacts() {
        return this.backingStore.get("impacts");
    }
    /**
     * Gets the @odata.type property value. The OdataType property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getOdataType() {
        return this.backingStore.get("odataType");
    }
    /**
     * Gets the state property value. The state property
     * @return a {@link EnrichmentState}
     */
    @jakarta.annotation.Nullable
    public EnrichmentState getState() {
        return this.backingStore.get("state");
    }
    /**
     * Gets the supportingData property value. A collection of supportingData locations that can be queried for debugging the alert.
     * @return a {@link SupportingData}
     */
    @jakarta.annotation.Nullable
    public SupportingData getSupportingData() {
        return this.backingStore.get("supportingData");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("impacts", this.getImpacts());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("state", this.getState());
        writer.writeObjectValue("supportingData", this.getSupportingData());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }
    /**
     * Sets the backingStore property value. Stores model information.
     * @param value Value to set for the backingStore property.
     */
    public void setBackingStore(@jakarta.annotation.Nonnull final BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }
    /**
     * Sets the impacts property value. A collection of resource impact summaries that gives a high level view of the kind of resources that were impacted and to what degree.
     * @param value Value to set for the impacts property.
     */
    public void setImpacts(@jakarta.annotation.Nullable final java.util.List<ResourceImpactSummary> value) {
        this.backingStore.set("impacts", value);
    }
    /**
     * Sets the @odata.type property value. The OdataType property
     * @param value Value to set for the @odata.type property.
     */
    public void setOdataType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("odataType", value);
    }
    /**
     * Sets the state property value. The state property
     * @param value Value to set for the state property.
     */
    public void setState(@jakarta.annotation.Nullable final EnrichmentState value) {
        this.backingStore.set("state", value);
    }
    /**
     * Sets the supportingData property value. A collection of supportingData locations that can be queried for debugging the alert.
     * @param value Value to set for the supportingData property.
     */
    public void setSupportingData(@jakarta.annotation.Nullable final SupportingData value) {
        this.backingStore.set("supportingData", value);
    }
}
