/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.auth.publicClient;

import com.microsoft.graph.auth.BaseAuthentication;
import com.microsoft.graph.auth.enums.NationalCloud;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import java.util.List;
import okhttp3.Request;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class UsernamePasswordProvider
extends BaseAuthentication
implements IAuthenticationProvider,
ICoreAuthenticationProvider {
    private String Username;
    private String Password;

    public UsernamePasswordProvider(String clientId, List<String> scopes, String username, String password) {
        this(clientId, scopes, username, password, NationalCloud.Global, "organizations", null);
    }

    public UsernamePasswordProvider(String clientId, List<String> scopes, String username, String password, NationalCloud nationalCloud, String tenant, String clientSecret) {
        super(scopes, clientId, UsernamePasswordProvider.GetAuthority(nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant == null ? "organizations" : tenant), null, nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant == null ? "organizations" : tenant, clientSecret);
        this.Username = username;
        this.Password = password;
    }

    public Request authenticateRequest(Request request) {
        String accessToken = this.getAccessToken();
        return request.newBuilder().addHeader("Authorization", "Bearer " + accessToken).build();
    }

    public void authenticateRequest(IHttpRequest request) {
        String accessToken = this.getAccessToken();
        request.addHeader("Authorization", "Bearer " + accessToken);
    }

    String getAccessToken() {
        String accessToken = this.getAccessTokenSilent();
        if (accessToken == null) {
            try {
                OAuthClientRequest authRequest = this.getTokenRequestMessage();
                accessToken = this.getAccessTokenNewRequest(authRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return accessToken;
    }

    OAuthClientRequest getTokenRequestMessage() throws OAuthSystemException {
        String tokenUrl = this.getAuthority() + "/oauth2/v2.0/token";
        OAuthClientRequest.TokenRequestBuilder token = OAuthClientRequest.tokenLocation((String)tokenUrl).setClientId(this.getClientId()).setUsername(this.Username).setPassword(this.Password).setGrantType(GrantType.PASSWORD).setScope(this.getScopesAsString());
        if (this.getClientSecret() != null) {
            token.setClientSecret(this.getClientSecret());
        }
        OAuthClientRequest request = token.buildBodyMessage();
        return request;
    }

    String getAccessTokenNewRequest(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        this.setStartTime(System.currentTimeMillis());
        this.setResponse(oAuthClient.accessToken(request));
        return this.getResponse().getAccessToken();
    }
}

