/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.auth.confidentialClient;

import com.microsoft.graph.auth.BaseAuthentication;
import com.microsoft.graph.auth.enums.NationalCloud;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import java.util.List;
import okhttp3.Request;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class AuthorizationCodeProvider
extends BaseAuthentication
implements IAuthenticationProvider,
ICoreAuthenticationProvider {
    public AuthorizationCodeProvider(String clientId, List<String> scopes, String authorizationCode, String redirectUri, String clientSecret) {
        this(clientId, scopes, authorizationCode, redirectUri, null, null, clientSecret);
    }

    public AuthorizationCodeProvider(String clientId, List<String> scopes, String authorizationCode, String redirectUri, NationalCloud nationalCloud, String tenant, String clientSecret) {
        super(scopes, clientId, AuthorizationCodeProvider.GetAuthority(nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant == null ? "common" : tenant), redirectUri, nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant == null ? "common" : tenant, clientSecret);
        this.getAccessToken(authorizationCode);
    }

    public Request authenticateRequest(Request request) {
        String tokenParameter = "Bearer " + this.getAccessTokenSilent();
        return request.newBuilder().addHeader("Authorization", tokenParameter).build();
    }

    public void authenticateRequest(IHttpRequest request) {
        String tokenParameter = "Bearer " + this.getAccessTokenSilent();
        request.addHeader("Authorization", tokenParameter);
    }

    void getAccessToken(String authorizationCode) {
        try {
            OAuthClientRequest request = this.getTokenRequestMessage(authorizationCode);
            this.getAccessTokenNewRequest(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    OAuthClientRequest getTokenRequestMessage(String authorizationCode) throws OAuthSystemException {
        String tokenUrl = this.getAuthority() + "/oauth2/v2.0/token";
        OAuthClientRequest.TokenRequestBuilder token = OAuthClientRequest.tokenLocation((String)tokenUrl).setClientId(this.getClientId()).setCode(authorizationCode).setRedirectURI(this.getRedirectUri()).setGrantType(GrantType.AUTHORIZATION_CODE).setScope(this.getScopesAsString());
        if (this.getClientSecret() != null) {
            token.setClientSecret(this.getClientSecret());
        }
        return token.buildBodyMessage();
    }

    void getAccessTokenNewRequest(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        this.setStartTime(System.currentTimeMillis());
        this.setResponse(oAuthClient.accessToken(request));
    }
}

