/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.azure.core.credential.TokenCredential;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.net.URI;
import java.util.ArrayList;

public final class SpeechTranslationConfig
extends SpeechConfig
implements AutoCloseable {
    private TokenCredential tokenCredential = null;
    private boolean disposed = false;

    private SpeechTranslationConfig(long l) {
        super(l);
    }

    private SpeechTranslationConfig(long l, TokenCredential tokenCredential) {
        this(l);
        this.tokenCredential = tokenCredential;
    }

    public static SpeechTranslationConfig fromSubscription(String string, String string2) {
        Contracts.throwIfIllegalSubscriptionKey(string, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(string2, "region");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromSubscription(intRef, string, string2));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public static SpeechTranslationConfig fromAuthorizationToken(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(string2, "region");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromAuthorizationToken(intRef, string, string2));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public static SpeechTranslationConfig fromEndpoint(URI uRI, String string) {
        Contracts.throwIfNull(uRI, "endpoint");
        if (string == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromEndpoint(intRef, uRI.toString(), string));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public static SpeechTranslationConfig fromEndpoint(URI uRI, TokenCredential tokenCredential) {
        Contracts.throwIfNull(uRI, "endpoint");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromEndpoint(intRef, uRI.toString(), null));
        return new SpeechTranslationConfig(intRef.getValue(), tokenCredential);
    }

    public void setCustomModelCategoryId(String string) {
        Contracts.throwIfNullOrWhitespace(string, "categoryId");
        Contracts.throwIfFail(this.setCustomModelCategoryId(super.getImpl(), string));
    }

    public static SpeechTranslationConfig fromEndpoint(URI uRI) {
        Contracts.throwIfNull(uRI, "endpoint");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromEndpoint(intRef, uRI.toString(), null));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public static SpeechTranslationConfig fromHost(URI uRI, String string) {
        Contracts.throwIfNull(uRI, "host");
        if (string == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromHost(intRef, uRI.toString(), string));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public static SpeechTranslationConfig fromHost(URI uRI) {
        Contracts.throwIfNull(uRI, "host");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromHost(intRef, uRI.toString(), null));
        return new SpeechTranslationConfig(intRef.getValue());
    }

    public void addTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.addTargetLanguage(super.getImpl(), string));
    }

    public void removeTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.removeTargetLanguage(super.getImpl(), string));
    }

    public ArrayList<String> getTargetLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getProperty(PropertyId.SpeechServiceConnection_TranslationToLanguages);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String getVoiceName() {
        return this.getProperty(PropertyId.SpeechServiceConnection_TranslationVoice);
    }

    public void setVoiceName(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        this.setProperty(PropertyId.SpeechServiceConnection_TranslationVoice, string);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        super.close();
        this.disposed = true;
    }

    @Override
    public SafeHandle getImpl() {
        return super.getImpl();
    }

    @Override
    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2);

    private static final native long fromEndpoint(IntRef var0, String var1, String var2);

    private static final native long fromHost(IntRef var0, String var1, String var2);

    private final native long addTargetLanguage(SafeHandle var1, String var2);

    private final native long removeTargetLanguage(SafeHandle var1, String var2);

    private final native long setCustomModelCategoryId(SafeHandle var1, String var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

