/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.diagnostics.logging;

import com.microsoft.cognitiveservices.speech.diagnostics.logging.Level;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Logger;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class EventLogger {
    private static final Object lockObj = new Object();
    private static EventHandler eventHandler = null;
    private static SafeHandle safeHandle = null;

    private EventLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallback(EventHandler eventHandler) {
        Object object = lockObj;
        synchronized (object) {
            if (eventHandler != null) {
                long l = System.identityHashCode(eventHandler);
                safeHandle = new SafeHandle(l, SafeHandleType.EventLoggerCallback);
                Contracts.throwIfNull(safeHandle, "safeHandle");
                EventLogger.eventHandler = eventHandler;
                Logger.setEventLoggingCallback(EventLogger.eventHandler, safeHandle.getValue());
            } else {
                EventLogger.eventHandler = null;
                safeHandle = null;
                Logger.setEventLoggingCallback(null, 0L);
            }
        }
    }

    public static void setCallback() {
        EventLogger.setCallback(null);
    }

    public static void setFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Logger.setEventLoggingFilters(stringArray);
    }

    public static void setFilters() {
        Logger.setEventLoggingFilters(new String[0]);
    }

    public static void setLevel(Level level) {
        Contracts.throwIfNull((Object)level, "level");
        Logger.setLevel(Logger.Type.Event, level);
    }

    public static interface EventHandler {
        public void logMessage(String var1);
    }
}

