/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfile;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.List;

public class SpeakerIdentificationModel
implements AutoCloseable {
    private boolean disposed = false;
    private SafeHandle speakerIdentificationModelHandle = null;

    public static SpeakerIdentificationModel fromProfiles(List<VoiceProfile> list) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfNull(list, "profiles cannot be null");
        Contracts.throwIfFail(SpeakerIdentificationModel.createSpeakerIdentificationModel(intRef));
        for (VoiceProfile voiceProfile : list) {
            Contracts.throwIfFail(SpeakerIdentificationModel.speakerIdentificationModelAddProfile(intRef, voiceProfile.getImpl()));
        }
        return new SpeakerIdentificationModel(intRef);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.speakerIdentificationModelHandle != null) {
            this.speakerIdentificationModelHandle.close();
            this.speakerIdentificationModelHandle = null;
        }
        this.disposed = true;
    }

    SpeakerIdentificationModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "modelHandle");
        this.speakerIdentificationModelHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SpeakerIdentificationModel);
    }

    public SafeHandle getImpl() {
        return this.speakerIdentificationModelHandle;
    }

    private static final native long createSpeakerIdentificationModel(IntRef var0);

    private static final native long speakerIdentificationModelAddProfile(IntRef var0, SafeHandle var1);

    static {
        Class<?> clazz = SpeechConfig.speechConfigClass;
    }
}

