/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public class IntentRecognitionEventArgs
extends RecognitionEventArgs {
    private IntentRecognitionResult result;

    IntentRecognitionEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    IntentRecognitionEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public final IntentRecognitionResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " ResultId:" + this.result.getResultId() + " Reason:" + (Object)((Object)this.result.getReason()) + " IntentId:<" + this.result.getIntentId() + "> Recognized text:<" + this.result.getText() + "> Recognized json:<" + this.result.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonResult) + "> LanguageUnderstandingJson <" + this.result.getProperties().getProperty(PropertyId.LanguageUnderstandingServiceResponse_JsonResult) + ">.";
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getRecognitionResult(this.eventHandle, intRef));
        this.result = new IntentRecognitionResult(intRef.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (bl) {
            super.close();
        }
    }
}

