/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.audio.PullAudioOutputStream;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class ActivityReceivedEventArgs {
    private SafeHandle activityReceivedEventHandle = null;
    private String activity = "";
    private boolean hasAudio = false;

    public ActivityReceivedEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        this.activityReceivedEventHandle = new SafeHandle(l, SafeHandleType.ActivityReceivedEvent);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getActivity(this.activityReceivedEventHandle, stringRef));
        this.activity = stringRef.getValue();
        this.hasAudio = this.hasAudio(this.activityReceivedEventHandle);
    }

    public String getActivity() {
        return this.activity;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public PullAudioOutputStream getAudio() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getAudio(this.activityReceivedEventHandle, intRef));
        return new PullAudioOutputStream(intRef);
    }

    private final native long getAudio(SafeHandle var1, IntRef var2);

    private final native long getActivity(SafeHandle var1, StringRef var2);

    private final native boolean hasAudio(SafeHandle var1);
}

