/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.List;

public final class AutoDetectSourceLanguageConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private boolean disposed = false;

    public static AutoDetectSourceLanguageConfig fromOpenRange() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AutoDetectSourceLanguageConfig.fromOpenRange(intRef));
        return new AutoDetectSourceLanguageConfig(intRef.getValue());
    }

    public static AutoDetectSourceLanguageConfig fromLanguages(List<String> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("languages cannot be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuilder.append(",");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AutoDetectSourceLanguageConfig.fromLanguages(intRef, stringBuilder.toString()));
        return new AutoDetectSourceLanguageConfig(intRef.getValue());
    }

    public static AutoDetectSourceLanguageConfig fromSourceLanguageConfigs(List<SourceLanguageConfig> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("sourceLanguageConfigs cannot be null or empty");
        }
        boolean bl = true;
        IntRef intRef = new IntRef(0L);
        for (SourceLanguageConfig sourceLanguageConfig : list) {
            Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig cannot be null");
            if (bl) {
                Contracts.throwIfFail(AutoDetectSourceLanguageConfig.createFromSourceLangConfig(intRef, sourceLanguageConfig.getImpl()));
                bl = false;
                continue;
            }
            Contracts.throwIfFail(AutoDetectSourceLanguageConfig.addSourceLangConfigToAutoDetectSourceLangConfig(intRef, sourceLanguageConfig.getImpl()));
        }
        return new AutoDetectSourceLanguageConfig(intRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private AutoDetectSourceLanguageConfig(long l) {
        Contracts.throwIfNull(l, "handleValue");
        this.configHandle = new SafeHandle(l, SafeHandleType.AutoDetectSourceLanguageConfig);
    }

    private static final native long fromOpenRange(IntRef var0);

    private static final native long fromLanguages(IntRef var0, String var1);

    private static final native long createFromSourceLangConfig(IntRef var0, SafeHandle var1);

    private static final native long addSourceLangConfigToAutoDetectSourceLangConfig(IntRef var0, SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

