/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionResult;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.StreamStatus;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class AudioDataStream
implements AutoCloseable {
    private SafeHandle streamHandle = null;
    private PropertyCollection propertyHandle;
    private boolean disposed = false;
    private final Object streamLock = new Object();
    private int activeAsyncActionCounter = 0;

    public static AudioDataStream fromResult(SpeechSynthesisResult speechSynthesisResult) {
        Contracts.throwIfNull(speechSynthesisResult, "result");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioDataStream.createFromResult(intRef, speechSynthesisResult.getImpl()));
        return new AudioDataStream(intRef);
    }

    public static AudioDataStream fromResult(KeywordRecognitionResult keywordRecognitionResult) {
        Contracts.throwIfNull(keywordRecognitionResult, "result");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioDataStream.createFromKeywordResult(intRef, keywordRecognitionResult.getImpl()));
        return new AudioDataStream(intRef);
    }

    public StreamStatus getStatus() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getStatus(this.streamHandle, intRef));
        return StreamStatus.values()[(int)intRef.getValue()];
    }

    public boolean canReadData(long l) {
        return this.canReadData(this.streamHandle, l);
    }

    public boolean canReadData(long l, long l2) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.canReadData(this.streamHandle, l, l2);
    }

    public long readData(byte[] byArray) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.readData(this.streamHandle, byArray, intRef));
        return intRef.getValue();
    }

    public long readData(long l, byte[] byArray) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException();
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.readData(this.streamHandle, byArray, l, intRef));
        return intRef.getValue();
    }

    public void saveToWavFile(String string) {
        Contracts.throwIfFail(this.saveToWaveFile(this.streamHandle, string));
    }

    public Future<Void> saveToWavFileAsync(String string) {
        final AudioDataStream audioDataStream = this;
        final String string2 = string;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(AudioDataStream.this.saveToWaveFile(audioDataStream.streamHandle, string2));
                    }
                };
                audioDataStream.doAsyncAction(runnable);
                return null;
            }
        });
    }

    public long getPosition() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPosition(this.streamHandle, intRef));
        return intRef.getValue();
    }

    public void setPosition(long l) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException();
        }
        Contracts.throwIfFail(this.setPosition(this.streamHandle, l));
    }

    public void detachInput() {
        Contracts.throwIfFail(this.detachInput(this.streamHandle));
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public SafeHandle getImpl() {
        return this.streamHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.activeAsyncActionCounter != 0) {
                throw new IllegalStateException("Cannot dispose an audio data stream while async saving to wave file is running. Await async operation to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    private AudioDataStream(IntRef intRef) {
        Contracts.throwIfNull(intRef, "stream");
        AsyncThreadService.initialize();
        this.streamHandle = new SafeHandle(intRef.getValue(), SafeHandleType.AudioDataStream);
        IntRef intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromStreamHandle(this.streamHandle, intRef2));
        this.propertyHandle = new PropertyCollection(intRef2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncAction(Runnable runnable) {
        Object object = this.streamLock;
        synchronized (object) {
            ++this.activeAsyncActionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.streamLock;
            synchronized (object) {
                --this.activeAsyncActionCounter;
            }
        }
    }

    private void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.streamHandle != null) {
                this.streamHandle.close();
                this.streamHandle = null;
            }
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private static final native long createFromResult(IntRef var0, SafeHandle var1);

    private static final native long createFromKeywordResult(IntRef var0, SafeHandle var1);

    private final native long getStatus(SafeHandle var1, IntRef var2);

    private final native boolean canReadData(SafeHandle var1, long var2);

    private final native boolean canReadData(SafeHandle var1, long var2, long var4);

    private final native long readData(SafeHandle var1, byte[] var2, IntRef var3);

    private final native long readData(SafeHandle var1, byte[] var2, long var3, IntRef var5);

    private final native long saveToWaveFile(SafeHandle var1, String var2);

    private final native long getPosition(SafeHandle var1, IntRef var2);

    private final native long setPosition(SafeHandle var1, long var2);

    private final native long detachInput(SafeHandle var1);

    private final native long getPropertyBagFromStreamHandle(SafeHandle var1, IntRef var2);
}

