/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.JsonValue;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class JsonValueJNI {
    private static long INVALID_ARG = 5L;

    public static JsonValue createParser(String string) {
        IntRef intRef = new IntRef(0L);
        int n = JsonValueJNI.createJsonParserHandle(string, intRef);
        SafeHandle safeHandle = new SafeHandle(intRef.getValue(), SafeHandleType.JSONVALUE);
        return new JsonValue(n, safeHandle);
    }

    public static String asString(SafeHandle safeHandle, int n) {
        if (JsonValueJNI.kind(safeHandle, n) != ValueKind.STRING.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asString(safeHandle, n, null);
    }

    public static long asInt(SafeHandle safeHandle, int n) {
        if (JsonValueJNI.kind(safeHandle, n) != ValueKind.NUMBER.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asInt(safeHandle, n, 0L);
    }

    public static float asFloat(SafeHandle safeHandle, int n) {
        if (JsonValueJNI.kind(safeHandle, n) != ValueKind.NUMBER.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return (float)JsonValueJNI.asDouble(safeHandle, n, 0.0);
    }

    public static boolean asBoolean(SafeHandle safeHandle, int n) {
        if (JsonValueJNI.kind(safeHandle, n) != ValueKind.BOOLEAN.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asBoolean(safeHandle, n, false);
    }

    public static JsonValue getValue(SafeHandle safeHandle, int n, int n2, String string) {
        int n3 = JsonValueJNI.get(safeHandle, n, n2, string);
        return new JsonValue(n3, safeHandle);
    }

    public static String getName(SafeHandle safeHandle, int n, int n2, String string) {
        String string2 = JsonValueJNI.getName(safeHandle, n, n2);
        return string2;
    }

    public static boolean hasValue(SafeHandle safeHandle, int n, int n2, String string) {
        return JsonValueJNI.get(safeHandle, n, n2, string) > 0;
    }

    public static final native int count(SafeHandle var0, int var1);

    public static final native String asJson(SafeHandle var0, int var1);

    private static final native int createJsonParserHandle(String var0, IntRef var1);

    private static final native long asInt(SafeHandle var0, int var1, long var2);

    private static final native String asString(SafeHandle var0, int var1, String var2);

    private static final native double asDouble(SafeHandle var0, int var1, double var2);

    private static final native boolean asBoolean(SafeHandle var0, int var1, boolean var2);

    private static final native int kind(SafeHandle var0, int var1);

    private static final native int get(SafeHandle var0, int var1, int var2, String var3);

    private static final native String getName(SafeHandle var0, int var1, int var2);

    static enum ValueKind {
        ERROR(-1),
        END(0),
        OBJECT(123),
        ARRAY(91),
        STRING(34),
        NUMBER(49),
        BOOLEAN(98),
        NULL(110),
        UNSPECIFIED(63);

        private int id;

        private ValueKind(int n2) {
            this.id = n2;
        }

        public int getValue() {
            return this.id;
        }
    }
}

