/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.translation.TranslationSynthesisEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class TranslationRecognizer
extends Recognizer {
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognized;
    public final EventHandlerImpl<TranslationRecognitionCanceledEventArgs> canceled;
    public final EventHandlerImpl<TranslationSynthesisEventArgs> synthesizing;
    static Set<TranslationRecognizer> translationRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;
    SafeHandle translationSynthesisHandle;

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(this.recoHandle, speechTranslationConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(this.recoHandle, speechTranslationConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(this.recoHandle, speechTranslationConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void addTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.addTargetLanguage(this.recoHandle, string));
    }

    public void removeTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.removeTargetLanguage(this.recoHandle, string));
    }

    public ArrayList<String> getTargetLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationToLanguages);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String getVoiceName() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationVoice);
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<TranslationRecognitionResult> recognizeOnceAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<TranslationRecognitionResult>(){

            @Override
            public TranslationRecognitionResult call() {
                final TranslationRecognitionResult[] translationRecognitionResultArray = new TranslationRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognitionResultArray[0] = new TranslationRecognitionResult(translationRecognizer.recognize());
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return translationRecognitionResultArray[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognizer.startContinuousRecognition(TranslationRecognizer.this.recoHandle);
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognizer.stopContinuousRecognition(TranslationRecognizer.this.recoHandle);
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.translationSynthesisHandle != null) {
                this.translationSynthesisHandle.close();
                this.translationSynthesisHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            translationRecognizerObjects.remove(this);
            super.dispose(bl);
        }
    }

    public SafeHandle getRecoImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final TranslationRecognizer translationRecognizer = this;
        this.translationSynthesisHandle = new SafeHandle(translationRecognizer.recoHandle.getValue(), SafeHandleType.TranslationSynthesis);
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizingSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizedSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.synthesizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.synthesizingSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.canceledSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStartedSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStoppedSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.speechStartDetectedSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.speechEndDetectedSetCallback(translationRecognizer.recoHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(translationRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs translationRecognitionEventArgs = new TranslationRecognitionEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs translationRecognitionEventArgs = new TranslationRecognitionEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionCanceledEventArgs translationRecognitionCanceledEventArgs = new TranslationRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationSynthesisEventArgs translationSynthesisEventArgs = new TranslationSynthesisEventArgs(l, true);
            EventHandlerImpl<TranslationSynthesisEventArgs> eventHandlerImpl = this.synthesizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createTranslationRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long synthesizingSetCallback(long var1);

    private final native long addTargetLanguage(SafeHandle var1, String var2);

    private final native long removeTargetLanguage(SafeHandle var1, String var2);
}

