/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisBookmarkEventArgs {
    private long audioOffset;
    private String text;

    SpeechSynthesisBookmarkEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        SafeHandle safeHandle = new SafeHandle(l, SafeHandleType.SynthesisEvent);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getBookmarkEventValues(safeHandle, intRef));
        this.audioOffset = intRef.getValue();
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getTextFromHandle(safeHandle, stringRef));
        this.text = stringRef.getValue();
        safeHandle.close();
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public String getText() {
        return this.text;
    }

    private final native long getBookmarkEventValues(SafeHandle var1, IntRef var2);

    private final native long getTextFromHandle(SafeHandle var1, StringRef var2);
}

