/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.HybridSpeechConfig;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class SpeechRecognizer
extends Recognizer {
    public final EventHandlerImpl<SpeechRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<SpeechRecognitionEventArgs> recognized;
    public final EventHandlerImpl<SpeechRecognitionCanceledEventArgs> canceled;
    static Set<SpeechRecognizer> speechRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public SpeechRecognizer(SpeechConfig speechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(this.recoHandle, "recoHandle");
        Contracts.throwIfFail(this.createSpeechRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        this.initialize();
    }

    public SpeechRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        this(embeddedSpeechConfig.config);
    }

    public SpeechRecognizer(HybridSpeechConfig hybridSpeechConfig) {
        this(hybridSpeechConfig.config);
    }

    public SpeechRecognizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createSpeechRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createSpeechRecognizerFromConfig(this.recoHandle, speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public SpeechRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        this(embeddedSpeechConfig.config, audioConfig);
    }

    public SpeechRecognizer(HybridSpeechConfig hybridSpeechConfig, AudioConfig audioConfig) {
        this(hybridSpeechConfig.config, audioConfig);
    }

    public SpeechRecognizer(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfFail(this.createSpeechRecognizerFromAutoDetectSourceLangConfig(this.recoHandle, speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public SpeechRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        this(embeddedSpeechConfig.config, autoDetectSourceLanguageConfig);
    }

    public SpeechRecognizer(HybridSpeechConfig hybridSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        this(hybridSpeechConfig.config, autoDetectSourceLanguageConfig);
    }

    public SpeechRecognizer(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createSpeechRecognizerFromAutoDetectSourceLangConfig(this.recoHandle, speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createSpeechRecognizerFromAutoDetectSourceLangConfig(this.recoHandle, speechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public SpeechRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        this(embeddedSpeechConfig.config, autoDetectSourceLanguageConfig, audioConfig);
    }

    public SpeechRecognizer(HybridSpeechConfig hybridSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        this(hybridSpeechConfig.config, autoDetectSourceLanguageConfig, audioConfig);
    }

    public SpeechRecognizer(SpeechConfig speechConfig, SourceLanguageConfig sourceLanguageConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig");
        Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), sourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public SpeechRecognizer(SpeechConfig speechConfig, SourceLanguageConfig sourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), sourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), sourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public SpeechRecognizer(SpeechConfig speechConfig, String string) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), null));
        this.initialize();
    }

    public SpeechRecognizer(SpeechConfig speechConfig, String string, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createSpeechRecognizerFromSourceLangConfig(this.recoHandle, speechConfig.getImpl(), SourceLanguageConfig.fromLanguage(string).getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getEndpointId() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_EndpointId);
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public OutputFormat getOutputFormat() {
        if (this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse).equals("true")) {
            return OutputFormat.Detailed;
        }
        return OutputFormat.Simple;
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<SpeechRecognitionResult> recognizeOnceAsync() {
        final SpeechRecognizer speechRecognizer = this;
        return AsyncThreadService.submit(new Callable<SpeechRecognitionResult>(){

            @Override
            public SpeechRecognitionResult call() {
                final SpeechRecognitionResult[] speechRecognitionResultArray = new SpeechRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        speechRecognitionResultArray[0] = new SpeechRecognitionResult(speechRecognizer.recognize());
                    }
                };
                speechRecognizer.doAsyncRecognitionAction(runnable);
                return speechRecognitionResultArray[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final SpeechRecognizer speechRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        speechRecognizer.startContinuousRecognition(SpeechRecognizer.this.recoHandle);
                    }
                };
                speechRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final SpeechRecognizer speechRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        speechRecognizer.stopContinuousRecognition(SpeechRecognizer.this.recoHandle);
                    }
                };
                speechRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startKeywordRecognitionAsync(KeywordRecognitionModel keywordRecognitionModel) {
        Contracts.throwIfNull(keywordRecognitionModel, "model");
        final SpeechRecognizer speechRecognizer = this;
        final KeywordRecognitionModel keywordRecognitionModel2 = keywordRecognitionModel;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        speechRecognizer.startKeywordRecognition(SpeechRecognizer.this.recoHandle, keywordRecognitionModel2.getImpl());
                    }
                };
                speechRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        final SpeechRecognizer speechRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        speechRecognizer.stopKeywordRecognition(SpeechRecognizer.this.recoHandle);
                    }
                };
                speechRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            speechRecognizerObjects.remove(this);
            super.dispose(bl);
        }
    }

    public SafeHandle getRecoImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final SpeechRecognizer speechRecognizer = this;
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.recognizingSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.recognizedSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.canceledSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.sessionStartedSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.sessionStoppedSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.speechStartDetectedSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                speechRecognizerObjects.add(speechRecognizer);
                Contracts.throwIfFail(SpeechRecognizer.this.speechEndDetectedSetCallback(speechRecognizer.recoHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(speechRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs speechRecognitionEventArgs = new SpeechRecognitionEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs speechRecognitionEventArgs = new SpeechRecognitionEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionCanceledEventArgs speechRecognitionCanceledEventArgs = new SpeechRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createSpeechRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long createSpeechRecognizerFromAutoDetectSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);

    private final native long createSpeechRecognizerFromSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);
}

