/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class KeywordRecognitionModel
implements AutoCloseable {
    private boolean disposed = false;
    private SafeHandle keywordModelHandle = null;

    public static KeywordRecognitionModel fromFile(String string) {
        Contracts.throwIfFileDoesNotExist(string, "fileName");
        try {
            File file = new File(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
            byte[] byArray = new byte[2];
            ((InputStream)bufferedInputStream).mark(4);
            int n = ((InputStream)bufferedInputStream).read(byArray);
            ((InputStream)bufferedInputStream).reset();
            boolean bl = n == 2 && byArray[0] == 80 && byArray[1] == 75;
            KeywordRecognitionModel keywordRecognitionModel = null;
            if (bl) {
                keywordRecognitionModel = KeywordRecognitionModel.fromStream(bufferedInputStream, file.getName(), bl);
                ((InputStream)bufferedInputStream).close();
            } else {
                ((InputStream)bufferedInputStream).close();
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(KeywordRecognitionModel.createKeywordRecognitionModelFromFile(file.getCanonicalPath(), intRef));
                keywordRecognitionModel = new KeywordRecognitionModel(intRef);
            }
            return keywordRecognitionModel;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("fileName not found");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("could not access file " + iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeywordRecognitionModel fromStream(InputStream inputStream, String string, boolean bl) throws IOException {
        File file;
        Object object;
        Contracts.throwIfNull(inputStream, "inputStream");
        Contracts.throwIfNullOrWhitespace(string, "name");
        if (string.contains(File.separator) || string.contains(".") || string.contains(":")) {
            throw new IOException("name must not contain separator, ., or :");
        }
        String string2 = System.getProperty("java.io.tmpdir");
        Contracts.throwIfNullOrWhitespace(string2, "tempFolder");
        String string3 = new File(string2).getCanonicalPath();
        Contracts.throwIfNullOrWhitespace(string3, "canonicalTempFolder");
        File file2 = new File(string3, "speech-sdk-keyword-" + string).getCanonicalFile();
        if (!file2.getCanonicalPath().startsWith(string3)) {
            throw new IOException("invalid kws temp directory " + file2.getCanonicalPath());
        }
        if (!file2.exists()) {
            int n;
            if (!file2.mkdirs()) {
                throw new IllegalArgumentException("cannot create directory");
            }
            file2.deleteOnExit();
            if (!file2.isDirectory()) {
                throw new IllegalArgumentException("path is not a directory");
            }
            object = new byte[0x100000];
            if (bl) {
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String string4 = "" + zipEntry.getName();
                    if (string4.length() > 128 || string4.contains("..")) {
                        string4 = "";
                    }
                    Contracts.throwIfNullOrWhitespace(string4, "zipEntry.name");
                    File file3 = new File(file2, string4);
                    if (!file3.getCanonicalPath().startsWith(file2.getCanonicalPath())) {
                        throw new IOException("invalid file " + file3.getCanonicalPath());
                    }
                    if (file3.exists() && !file3.delete()) {
                        throw new IllegalArgumentException("could not delete " + file3.getCanonicalPath());
                    }
                    file3.deleteOnExit();
                    FileOutputStream fileOutputStream2 = null;
                    try {
                        fileOutputStream2 = new FileOutputStream(file3);
                        while ((n = zipInputStream.read((byte[])object)) > 0) {
                            fileOutputStream2.write((byte[])object, 0, n);
                        }
                    }
                    catch (Throwable throwable) {
                        KeywordRecognitionModel.safeClose(fileOutputStream2);
                        throw throwable;
                    }
                    KeywordRecognitionModel.safeClose(fileOutputStream2);
                }
                zipInputStream.close();
            } else {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(new File(file2, "kws.table"));
                    while ((n = inputStream.read((byte[])object)) > 0) {
                        fileOutputStream.write((byte[])object, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    KeywordRecognitionModel.safeClose(fileOutputStream);
                    throw throwable;
                }
                KeywordRecognitionModel.safeClose(fileOutputStream);
            }
        }
        if ((file = new File(file2, "kws.table")).exists() && file.isFile()) {
            object = new IntRef(0L);
            Contracts.throwIfFail(KeywordRecognitionModel.createKeywordRecognitionModelFromFile(file.getCanonicalPath(), (IntRef)object));
            return new KeywordRecognitionModel((IntRef)object);
        }
        throw new IllegalArgumentException("zip did not contain kws.table");
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.keywordModelHandle != null) {
            this.keywordModelHandle.close();
            this.keywordModelHandle = null;
        }
        this.disposed = true;
    }

    KeywordRecognitionModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "modelHandle");
        this.keywordModelHandle = new SafeHandle(intRef.getValue(), SafeHandleType.KeywordModel);
    }

    public SafeHandle getImpl() {
        return this.keywordModelHandle;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final native long createKeywordRecognitionModelFromFile(String var0, IntRef var1);

    static {
        Class<?> clazz = SpeechConfig.speechConfigClass;
    }
}

