/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.TelemetryManager;

public final class HybridSpeechConfig
implements AutoCloseable {
    SpeechConfig config = null;
    private boolean disposed = false;

    HybridSpeechConfig(long l) {
        this.config = new SpeechConfig(l);
        TelemetryManager.getSingleton();
    }

    public static final HybridSpeechConfig fromConfigs(SpeechConfig speechConfig, EmbeddedSpeechConfig embeddedSpeechConfig) {
        Contracts.throwIfNull(speechConfig, "cloudSpeechConfig");
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(HybridSpeechConfig.createHybridSpeechConfig(intRef, speechConfig.getImpl(), embeddedSpeechConfig.config.getImpl()));
        HybridSpeechConfig hybridSpeechConfig = new HybridSpeechConfig(intRef.getValue());
        return hybridSpeechConfig;
    }

    public final void setSpeechRecognitionOutputFormat(OutputFormat outputFormat) {
        this.config.setOutputFormat(outputFormat);
    }

    public final OutputFormat getSpeechRecognitionOutputFormat() {
        return this.config.getOutputFormat();
    }

    public final void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat speechSynthesisOutputFormat) {
        this.config.setSpeechSynthesisOutputFormat(speechSynthesisOutputFormat);
    }

    public final String getSpeechSynthesisOutputFormat() {
        return this.config.getSpeechSynthesisOutputFormat();
    }

    public void setProperty(String string, String string2) {
        this.config.setProperty(string, string2);
    }

    public void setProperty(PropertyId propertyId, String string) {
        this.config.setProperty(propertyId, string);
    }

    public String getProperty(String string) {
        return this.config.getProperty(string);
    }

    public String getProperty(PropertyId propertyId) {
        return this.config.getProperty(propertyId);
    }

    @Override
    public final void close() {
        if (this.disposed) {
            return;
        }
        if (this.config != null) {
            this.config.close();
            this.config = null;
        }
        this.disposed = true;
    }

    private static final native long createHybridSpeechConfig(IntRef var0, SafeHandle var1, SafeHandle var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

