/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ConnectionEventArgs;
import com.microsoft.cognitiveservices.speech.ConnectionMessageEventArgs;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechSynthesizer;
import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConnector;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslator;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public final class Connection
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<ConnectionEventArgs> connected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConnectionEventArgs> disconnected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConnectionMessageEventArgs> messageReceived = new EventHandlerImpl(this.eventCounter);
    static Set<Connection> _connectionObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle connectionHandle;
    private boolean disposed = false;
    private final Object connectionLock = new Object();
    private int activeAsyncConnectionCounter = 0;

    public static Connection fromRecognizer(Recognizer recognizer) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromRecognizer(recognizer.getImpl(), intRef));
        return new Connection(intRef);
    }

    public static Connection fromConversationTranslator(ConversationTranslator conversationTranslator) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromConversationTranslator(conversationTranslator.getImpl(), intRef));
        return new Connection(intRef);
    }

    public static Connection fromDialogServiceConnector(DialogServiceConnector dialogServiceConnector) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromDialogServiceConnector(dialogServiceConnector.getImpl(), intRef));
        return new Connection(intRef);
    }

    public static Connection fromSpeechSynthesizer(SpeechSynthesizer speechSynthesizer) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromSpeechSynthesizer(speechSynthesizer.getImpl(), intRef));
        return new Connection(intRef);
    }

    public void openConnection(boolean bl) {
        Contracts.throwIfFail(this.openConnection(this.connectionHandle, bl));
    }

    public void closeConnection() {
        Contracts.throwIfFail(this.closeConnection(this.connectionHandle));
    }

    public Future<Void> sendMessageAsync(String string, String string2) {
        final Connection connection = this;
        final String string3 = string;
        final String string4 = string2;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Connection.this.connectionSendMessage(Connection.this.connectionHandle, string3, string4));
                    }
                };
                connection.doAsyncConnectionAction(runnable);
                return null;
            }
        });
    }

    public void setMessageProperty(String string, String string2, String string3) {
        Contracts.throwIfFail(this.connectionSetMessageProperty(this.connectionHandle, string, string2, string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncConnectionAction(Runnable runnable) {
        Object object = this.connectionLock;
        synchronized (object) {
            ++this.activeAsyncConnectionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.connectionLock;
            synchronized (object) {
                --this.activeAsyncConnectionCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.activeAsyncConnectionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a connection while async method is running. Await async method to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.connectionHandle != null) {
                this.connectionHandle.close();
                this.connectionHandle = null;
            }
            _connectionObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private Connection(IntRef intRef) {
        Contracts.throwIfNull(intRef, "Connection");
        this.connectionHandle = new SafeHandle(intRef.getValue(), SafeHandleType.Connection);
        this.initialize();
    }

    private void initialize() {
        final Connection connection = this;
        AsyncThreadService.initialize();
        this.connected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(connection);
                Connection.this.connectionConnectedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
        this.disconnected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(connection);
                Connection.this.connectionDisconnectedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
        this.messageReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(connection);
                Connection.this.connectionMessageReceivedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
    }

    private void connectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionEventArgs connectionEventArgs = new ConnectionEventArgs(l, true);
            EventHandlerImpl<ConnectionEventArgs> eventHandlerImpl = this.connected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, connectionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disconnectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionEventArgs connectionEventArgs = new ConnectionEventArgs(l, true);
            EventHandlerImpl<ConnectionEventArgs> eventHandlerImpl = this.disconnected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, connectionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void messageReceivedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionMessageEventArgs connectionMessageEventArgs = new ConnectionMessageEventArgs(l);
            EventHandlerImpl<ConnectionMessageEventArgs> eventHandlerImpl = this.messageReceived;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, connectionMessageEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final native long connectionFromRecognizer(SafeHandle var0, IntRef var1);

    private static final native long connectionFromConversationTranslator(SafeHandle var0, IntRef var1);

    private static final native long connectionFromDialogServiceConnector(SafeHandle var0, IntRef var1);

    private static final native long connectionFromSpeechSynthesizer(SafeHandle var0, IntRef var1);

    private final native long openConnection(SafeHandle var1, boolean var2);

    private final native long closeConnection(SafeHandle var1);

    private final native long connectionSendMessage(SafeHandle var1, String var2, String var3);

    private final native long connectionSetMessageProperty(SafeHandle var1, String var2, String var3, String var4);

    private final native long connectionConnectedSetCallback(long var1);

    private final native long connectionDisconnectedSetCallback(long var1);

    private final native long connectionMessageReceivedSetCallback(long var1);
}

