/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.connector.ConnectorClient;
import java.util.HashMap;
import java.util.Map;

public class TurnContextStateCollection
implements AutoCloseable {
    private Map<String, Object> state = new HashMap<String, Object>();

    public <T> T get(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        Object service = this.state.get(key);
        try {
            return (T)service;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Map<String, Object> getTurnStateServices() {
        return this.state;
    }

    public <T> T get(Class<T> type) {
        return this.get(type.getName());
    }

    public <T> void add(String key, T value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        if (this.state.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Key %s already exists", key));
        }
        this.state.put(key, value);
    }

    public <T> void add(T value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        this.add(value.getClass().getName(), value);
    }

    public void remove(String key) {
        this.state.remove(key);
    }

    public void replace(String key, Object value) {
        this.state.remove(key);
        this.add(key, value);
    }

    public <T> void replace(T value) {
        String key = value.getClass().getName();
        this.replace(key, value);
    }

    public boolean containsKey(String key) {
        return this.state.containsKey(key);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry<String, Object> entry : this.state.entrySet()) {
            if (!(entry.getValue() instanceof AutoCloseable) || entry.getValue() instanceof ConnectorClient) continue;
            ((AutoCloseable)entry.getValue()).close();
        }
    }

    public void copy(TurnContextStateCollection other) {
        if (other != null) {
            for (String key : other.state.keySet()) {
                this.state.put(key, other.state.get(key));
            }
        }
    }
}

