/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.BotAdapter;
import com.microsoft.bot.builder.DeleteActivityHandler;
import com.microsoft.bot.builder.SendActivitiesHandler;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.TurnContextStateCollection;
import com.microsoft.bot.builder.UpdateActivityHandler;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.DeliveryModes;
import com.microsoft.bot.schema.InputHints;
import com.microsoft.bot.schema.ResourceResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class TurnContextImpl
implements TurnContext,
AutoCloseable {
    private final BotAdapter adapter;
    private final Activity activity;
    private List<Activity> bufferedReplyActivities = new ArrayList<Activity>();
    private final List<SendActivitiesHandler> onSendActivities = new ArrayList<SendActivitiesHandler>();
    private final List<UpdateActivityHandler> onUpdateActivity = new ArrayList<UpdateActivityHandler>();
    private final List<DeleteActivityHandler> onDeleteActivity = new ArrayList<DeleteActivityHandler>();
    private final TurnContextStateCollection turnState;
    private Boolean responded = false;

    public TurnContextImpl(BotAdapter withAdapter, Activity withActivity) {
        if (withAdapter == null) {
            throw new IllegalArgumentException("adapter");
        }
        this.adapter = withAdapter;
        if (withActivity == null) {
            throw new IllegalArgumentException("activity");
        }
        this.activity = withActivity;
        this.turnState = new TurnContextStateCollection();
    }

    @Override
    public TurnContext onSendActivities(SendActivitiesHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler");
        }
        this.onSendActivities.add(handler);
        return this;
    }

    @Override
    public TurnContext onUpdateActivity(UpdateActivityHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler");
        }
        this.onUpdateActivity.add(handler);
        return this;
    }

    @Override
    public TurnContext onDeleteActivity(DeleteActivityHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler");
        }
        this.onDeleteActivity.add(handler);
        return this;
    }

    @Override
    public BotAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public TurnContextStateCollection getTurnState() {
        return this.turnState;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public boolean getResponded() {
        return this.responded;
    }

    @Override
    public String getLocale() {
        return (String)this.getTurnState().get("turn.locale");
    }

    @Override
    public void setLocale(String withLocale) {
        if (StringUtils.isEmpty((CharSequence)withLocale)) {
            this.getTurnState().remove("turn.locale");
        } else if (LocaleUtils.isAvailableLocale((Locale)new Locale.Builder().setLanguageTag(withLocale).build())) {
            this.getTurnState().replace("turn.locale", withLocale);
        } else {
            this.getTurnState().replace("turn.locale", Locale.ENGLISH.getCountry());
        }
    }

    public List<Activity> getBufferedReplyActivities() {
        return this.bufferedReplyActivities;
    }

    @Override
    public CompletableFuture<ResourceResponse> sendActivity(String textReplyToSend) {
        return this.sendActivity(textReplyToSend, null, null);
    }

    @Override
    public CompletableFuture<ResourceResponse> sendActivity(String textReplyToSend, String speak) {
        return this.sendActivity(textReplyToSend, speak, null);
    }

    @Override
    public CompletableFuture<ResourceResponse> sendActivity(String textReplyToSend, String speak, InputHints inputHint) {
        if (StringUtils.isEmpty((CharSequence)textReplyToSend)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("textReplyToSend"));
        }
        Activity activityToSend = new Activity("message");
        activityToSend.setText(textReplyToSend);
        if (StringUtils.isNotEmpty((CharSequence)speak)) {
            activityToSend.setSpeak(speak);
        }
        if (inputHint != null) {
            activityToSend.setInputHint(inputHint);
        }
        return this.sendActivity(activityToSend);
    }

    @Override
    public CompletableFuture<ResourceResponse> sendActivity(Activity activityToSend) {
        if (activityToSend == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Activity"));
        }
        return this.sendActivities(Collections.singletonList(activityToSend)).thenApply(resourceResponses -> {
            if (resourceResponses == null || ((ResourceResponse[])resourceResponses).length == 0) {
                return new ResourceResponse();
            }
            return resourceResponses[0];
        });
    }

    @Override
    public CompletableFuture<ResourceResponse[]> sendActivities(List<Activity> activities) {
        if (activities == null || activities.size() == 0) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("activities"));
        }
        ConversationReference cr = this.activity.getConversationReference();
        List<Activity> bufferedActivities = activities.stream().map(a -> a.applyConversationReference(cr)).collect(Collectors.toList());
        if (this.onSendActivities.size() == 0) {
            return this.sendActivitiesThroughAdapter(bufferedActivities);
        }
        return this.sendActivitiesThroughCallbackPipeline(bufferedActivities, 0);
    }

    private CompletableFuture<ResourceResponse[]> sendActivitiesThroughAdapter(List<Activity> activities) {
        if (DeliveryModes.fromString((String)this.getActivity().getDeliveryMode()) == DeliveryModes.EXPECT_REPLIES) {
            ResourceResponse[] responses2 = new ResourceResponse[activities.size()];
            boolean sentNonTraceActivity = false;
            for (int index = 0; index < responses2.length; ++index) {
                Activity sendActivity = activities.get(index);
                this.bufferedReplyActivities.add(sendActivity);
                if (this.activity.isType("invokeResponse")) {
                    this.getTurnState().add("BotFrameworkAdapter.InvokeResponse", this.activity);
                }
                responses2[index] = new ResourceResponse();
                sentNonTraceActivity |= !sendActivity.isType("trace");
            }
            if (sentNonTraceActivity) {
                this.responded = true;
            }
            return CompletableFuture.completedFuture(responses2);
        }
        return this.adapter.sendActivities(this, activities).thenApply(responses -> {
            boolean sentNonTraceActivity = false;
            for (int index = 0; index < ((ResourceResponse[])responses).length; ++index) {
                Activity sendActivity = (Activity)activities.get(index);
                sendActivity.setId(responses[index].getId());
                sentNonTraceActivity |= !sendActivity.isType("trace");
            }
            if (sentNonTraceActivity) {
                this.responded = true;
            }
            return responses;
        });
    }

    private CompletableFuture<ResourceResponse[]> sendActivitiesThroughCallbackPipeline(List<Activity> activities, int nextCallbackIndex) {
        if (nextCallbackIndex == this.onSendActivities.size()) {
            return this.sendActivitiesThroughAdapter(activities);
        }
        return this.onSendActivities.get(nextCallbackIndex).invoke(this, activities, () -> this.sendActivitiesThroughCallbackPipeline(activities, nextCallbackIndex + 1));
    }

    @Override
    public CompletableFuture<ResourceResponse> updateActivity(Activity withActivity) {
        if (withActivity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Activity"));
        }
        ConversationReference conversationReference = this.activity.getConversationReference();
        withActivity.applyConversationReference(conversationReference);
        Supplier<CompletableFuture<ResourceResponse>> actuallyUpdateStuff = () -> this.getAdapter().updateActivity(this, withActivity);
        return this.updateActivityInternal(withActivity, this.onUpdateActivity.iterator(), actuallyUpdateStuff);
    }

    private CompletableFuture<ResourceResponse> updateActivityInternal(Activity updateActivity, Iterator<UpdateActivityHandler> updateHandlers, Supplier<CompletableFuture<ResourceResponse>> callAtBottom) {
        if (updateActivity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Activity"));
        }
        if (updateHandlers == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("updateHandlers"));
        }
        if (!updateHandlers.hasNext()) {
            if (callAtBottom != null) {
                return callAtBottom.get();
            }
            return CompletableFuture.completedFuture(null);
        }
        Supplier<CompletableFuture<ResourceResponse>> next = () -> {
            if (updateHandlers.hasNext()) {
                updateHandlers.next();
            }
            return this.updateActivityInternal(updateActivity, updateHandlers, callAtBottom).thenApply(resourceResponse -> {
                updateActivity.setId(resourceResponse.getId());
                return resourceResponse;
            });
        };
        UpdateActivityHandler toCall = updateHandlers.next();
        return toCall.invoke(this, updateActivity, next);
    }

    @Override
    public CompletableFuture<Void> deleteActivity(String activityId) {
        if (StringUtils.isWhitespace((CharSequence)activityId) || StringUtils.isEmpty((CharSequence)activityId)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("activityId"));
        }
        ConversationReference cr = this.activity.getConversationReference();
        cr.setActivityId(activityId);
        Supplier<CompletableFuture<Void>> actuallyDeleteStuff = () -> this.getAdapter().deleteActivity(this, cr);
        return this.deleteActivityInternal(cr, this.onDeleteActivity.iterator(), actuallyDeleteStuff);
    }

    @Override
    public CompletableFuture<Void> deleteActivity(ConversationReference conversationReference) {
        if (conversationReference == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("conversationReference"));
        }
        Supplier<CompletableFuture<Void>> actuallyDeleteStuff = () -> this.getAdapter().deleteActivity(this, conversationReference);
        return this.deleteActivityInternal(conversationReference, this.onDeleteActivity.iterator(), actuallyDeleteStuff);
    }

    private CompletableFuture<Void> deleteActivityInternal(ConversationReference cr, Iterator<DeleteActivityHandler> deleteHandlers, Supplier<CompletableFuture<Void>> callAtBottom) {
        if (cr == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("ConversationReference"));
        }
        if (deleteHandlers == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("deleteHandlers"));
        }
        if (!deleteHandlers.hasNext()) {
            if (callAtBottom != null) {
                return callAtBottom.get();
            }
            return CompletableFuture.completedFuture(null);
        }
        Supplier<CompletableFuture<Void>> next = () -> {
            if (deleteHandlers.hasNext()) {
                deleteHandlers.next();
            }
            return this.deleteActivityInternal(cr, deleteHandlers, callAtBottom);
        };
        DeleteActivityHandler toCall = deleteHandlers.next();
        return toCall.invoke(this, cr, next);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        this.turnState.close();
    }
}

