/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.BotCallbackHandler;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.MiddlewareSet;
import com.microsoft.bot.builder.OnTurnErrorHandler;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.TurnContextImpl;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.ResourceResponse;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public abstract class BotAdapter {
    public static final String BOT_IDENTITY_KEY = "BotIdentity";
    public static final String OAUTH_SCOPE_KEY = "Microsoft.Bot.Builder.BotAdapter.OAuthScope";
    public static final String OAUTH_CLIENT_KEY = "OAuthClient";
    private final MiddlewareSet middlewareSet = new MiddlewareSet();
    private OnTurnErrorHandler onTurnError;

    public OnTurnErrorHandler getOnTurnError() {
        return this.onTurnError;
    }

    public void setOnTurnError(OnTurnErrorHandler withTurnError) {
        this.onTurnError = withTurnError;
    }

    protected MiddlewareSet getMiddlewareSet() {
        return this.middlewareSet;
    }

    public BotAdapter use(Middleware middleware) {
        this.middlewareSet.use(middleware);
        return this;
    }

    public abstract CompletableFuture<ResourceResponse[]> sendActivities(TurnContext var1, List<Activity> var2);

    public abstract CompletableFuture<ResourceResponse> updateActivity(TurnContext var1, Activity var2);

    public abstract CompletableFuture<Void> deleteActivity(TurnContext var1, ConversationReference var2);

    protected CompletableFuture<Void> runPipeline(TurnContext context, BotCallbackHandler callback) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (context.getActivity() != null) {
            if (!StringUtils.isEmpty((CharSequence)context.getActivity().getLocale())) {
                Locale.setDefault(Locale.forLanguageTag(context.getActivity().getLocale()));
                context.setLocale(context.getActivity().getLocale());
            }
            return this.middlewareSet.receiveActivityWithStatus(context, callback).exceptionally(exception -> {
                if (this.onTurnError != null) {
                    return this.onTurnError.invoke(context, (Throwable)exception).join();
                }
                throw new CompletionException((Throwable)exception);
            });
        }
        if (callback != null) {
            return callback.invoke(context);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> continueConversation(String botAppId, ConversationReference reference, BotCallbackHandler callback) {
        CompletableFuture<Void> pipelineResult = new CompletableFuture<Void>();
        try (TurnContextImpl context = new TurnContextImpl(this, reference.getContinuationActivity());){
            pipelineResult = this.runPipeline(context, callback);
        }
        catch (Exception e) {
            pipelineResult.completeExceptionally(e);
        }
        return pipelineResult;
    }

    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, ConversationReference reference, BotCallbackHandler callback) {
        return Async.completeExceptionally((Throwable)new NotImplementedException("continueConversation"));
    }

    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, ConversationReference reference, String audience, BotCallbackHandler callback) {
        return Async.completeExceptionally((Throwable)new NotImplementedException("continueConversation"));
    }

    public CompletableFuture<Void> continueConversation(String botId, Activity continuationActivity, BotCallbackHandler callback) {
        return Async.completeExceptionally((Throwable)new NotImplementedException("continueConversation"));
    }

    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, Activity continuationActivity, BotCallbackHandler callback) {
        return Async.completeExceptionally((Throwable)new NotImplementedException("continueConversation"));
    }

    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, Activity continuationActivity, String audience, BotCallbackHandler callback) {
        return Async.completeExceptionally((Throwable)new NotImplementedException("continueConversation"));
    }
}

