/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkLocationTargetBidWithStringLocation;
import com.microsoft.bingads.bulk.entities.BulkTargetWithLocation;
import com.microsoft.bingads.bulk.entities.LocationTargetType;
import com.microsoft.bingads.campaignmanagement.ArrayOfCityTargetBid;
import com.microsoft.bingads.campaignmanagement.ArrayOfCountryTargetBid;
import com.microsoft.bingads.campaignmanagement.ArrayOfMetroAreaTargetBid;
import com.microsoft.bingads.campaignmanagement.ArrayOfPostalCodeTargetBid;
import com.microsoft.bingads.campaignmanagement.ArrayOfStateTargetBid;
import com.microsoft.bingads.campaignmanagement.CityTarget;
import com.microsoft.bingads.campaignmanagement.CityTargetBid;
import com.microsoft.bingads.campaignmanagement.CountryTarget;
import com.microsoft.bingads.campaignmanagement.CountryTargetBid;
import com.microsoft.bingads.campaignmanagement.LocationTarget2;
import com.microsoft.bingads.campaignmanagement.MetroAreaTarget;
import com.microsoft.bingads.campaignmanagement.MetroAreaTargetBid;
import com.microsoft.bingads.campaignmanagement.PostalCodeTarget;
import com.microsoft.bingads.campaignmanagement.PostalCodeTargetBid;
import com.microsoft.bingads.campaignmanagement.StateTarget;
import com.microsoft.bingads.campaignmanagement.StateTargetBid;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import java.util.ArrayList;
import java.util.List;

abstract class BulkLocationTargetWithStringLocation<TBid extends BulkLocationTargetBidWithStringLocation>
extends BulkTargetWithLocation<TBid> {
    public BulkLocationTargetWithStringLocation(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    public PostalCodeTarget getPostalCodeTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, PostalCodeTarget>(){

            @Override
            public PostalCodeTarget apply(LocationTarget2 t) {
                return t.getPostalCodeTarget();
            }
        });
    }

    public void setPostalCodeTarget(final PostalCodeTarget postalCodeTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setPostalCodeTarget(postalCodeTarget);
            }
        });
    }

    public CityTarget getCityTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, CityTarget>(){

            @Override
            public CityTarget apply(LocationTarget2 t) {
                return t.getCityTarget();
            }
        });
    }

    public void setCityTarget(final CityTarget cityTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setCityTarget(cityTarget);
            }
        });
    }

    public MetroAreaTarget getMetroAreaTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, MetroAreaTarget>(){

            @Override
            public MetroAreaTarget apply(LocationTarget2 t) {
                return t.getMetroAreaTarget();
            }
        });
    }

    public void setMetroAreaTarget(final MetroAreaTarget cityTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setMetroAreaTarget(cityTarget);
            }
        });
    }

    public StateTarget getStateTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, StateTarget>(){

            @Override
            public StateTarget apply(LocationTarget2 t) {
                return t.getStateTarget();
            }
        });
    }

    public void setStateTarget(final StateTarget stateTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setStateTarget(stateTarget);
            }
        });
    }

    public CountryTarget getCountryTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, CountryTarget>(){

            @Override
            public CountryTarget apply(LocationTarget2 t) {
                return t.getCountryTarget();
            }
        });
    }

    public void setCountryTarget(final CountryTarget countryTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setCountryTarget(countryTarget);
            }
        });
    }

    abstract void setPostalCodeBidAdditionialProperties(PostalCodeTargetBid var1, TBid var2);

    abstract void setCityBidAdditionialProperties(CityTargetBid var1, TBid var2);

    abstract void setMetroAreaBidAdditionialProperties(MetroAreaTargetBid var1, TBid var2);

    abstract void setStateBidAdditionialProperties(StateTargetBid var1, TBid var2);

    abstract void setCountryBidAdditionialProperties(CountryTargetBid var1, TBid var2);

    @Override
    void reconstructSubTargets() {
        this.reconstructApiBids(LocationTargetType.POSTAL_CODE, new Function<TBid, PostalCodeTargetBid>(){

            @Override
            public PostalCodeTargetBid apply(TBid t) {
                PostalCodeTargetBid postalCodeBid = new PostalCodeTargetBid();
                postalCodeBid.setPostalCode(((BulkLocationTargetBidWithStringLocation)t).getLocation());
                BulkLocationTargetWithStringLocation.this.setPostalCodeBidAdditionialProperties(postalCodeBid, t);
                return postalCodeBid;
            }
        }, new Supplier<PostalCodeTarget>(){

            @Override
            public PostalCodeTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getPostalCodeTarget();
            }
        }, new Supplier<PostalCodeTarget>(){

            @Override
            public PostalCodeTarget get() {
                return new PostalCodeTarget();
            }
        }, new Consumer<PostalCodeTarget>(){

            @Override
            public void accept(PostalCodeTarget t) {
                BulkLocationTargetWithStringLocation.this.getLocation().setPostalCodeTarget(t);
            }
        }, new Supplier<List<PostalCodeTargetBid>>(){

            @Override
            public List<PostalCodeTargetBid> get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getPostalCodeTarget().getBids().getPostalCodeTargetBids();
            }
        }, new Consumer<List<PostalCodeTargetBid>>(){

            @Override
            public void accept(List<PostalCodeTargetBid> t) {
                BulkLocationTargetWithStringLocation.this.getLocation().getPostalCodeTarget().setBids(new ArrayOfPostalCodeTargetBid());
                BulkLocationTargetWithStringLocation.this.getLocation().getPostalCodeTarget().getBids().getPostalCodeTargetBids().addAll(t);
            }
        });
        this.reconstructApiBids(LocationTargetType.CITY, new Function<TBid, CityTargetBid>(){

            @Override
            public CityTargetBid apply(TBid t) {
                CityTargetBid cityBid = new CityTargetBid();
                cityBid.setCity(((BulkLocationTargetBidWithStringLocation)t).getLocation());
                BulkLocationTargetWithStringLocation.this.setCityBidAdditionialProperties(cityBid, t);
                return cityBid;
            }
        }, new Supplier<CityTarget>(){

            @Override
            public CityTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCityTarget();
            }
        }, new Supplier<CityTarget>(){

            @Override
            public CityTarget get() {
                return new CityTarget();
            }
        }, new Consumer<CityTarget>(){

            @Override
            public void accept(CityTarget t) {
                BulkLocationTargetWithStringLocation.this.getLocation().setCityTarget(t);
            }
        }, new Supplier<List<CityTargetBid>>(){

            @Override
            public List<CityTargetBid> get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCityTarget().getBids().getCityTargetBids();
            }
        }, new Consumer<List<CityTargetBid>>(){

            @Override
            public void accept(List<CityTargetBid> t) {
                BulkLocationTargetWithStringLocation.this.getLocation().getCityTarget().setBids(new ArrayOfCityTargetBid());
                BulkLocationTargetWithStringLocation.this.getLocation().getCityTarget().getBids().getCityTargetBids().addAll(t);
            }
        });
        this.reconstructApiBids(LocationTargetType.METRO_AREA, new Function<TBid, MetroAreaTargetBid>(){

            @Override
            public MetroAreaTargetBid apply(TBid t) {
                MetroAreaTargetBid metroArea = new MetroAreaTargetBid();
                metroArea.setMetroArea(((BulkLocationTargetBidWithStringLocation)t).getLocation());
                BulkLocationTargetWithStringLocation.this.setMetroAreaBidAdditionialProperties(metroArea, t);
                return metroArea;
            }
        }, new Supplier<MetroAreaTarget>(){

            @Override
            public MetroAreaTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getMetroAreaTarget();
            }
        }, new Supplier<MetroAreaTarget>(){

            @Override
            public MetroAreaTarget get() {
                return new MetroAreaTarget();
            }
        }, new Consumer<MetroAreaTarget>(){

            @Override
            public void accept(MetroAreaTarget t) {
                BulkLocationTargetWithStringLocation.this.getLocation().setMetroAreaTarget(t);
            }
        }, new Supplier<List<MetroAreaTargetBid>>(){

            @Override
            public List<MetroAreaTargetBid> get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getMetroAreaTarget().getBids().getMetroAreaTargetBids();
            }
        }, new Consumer<List<MetroAreaTargetBid>>(){

            @Override
            public void accept(List<MetroAreaTargetBid> t) {
                BulkLocationTargetWithStringLocation.this.getLocation().getMetroAreaTarget().setBids(new ArrayOfMetroAreaTargetBid());
                BulkLocationTargetWithStringLocation.this.getLocation().getMetroAreaTarget().getBids().getMetroAreaTargetBids().addAll(t);
            }
        });
        this.reconstructApiBids(LocationTargetType.STATE, new Function<TBid, StateTargetBid>(){

            @Override
            public StateTargetBid apply(TBid t) {
                StateTargetBid stateBid = new StateTargetBid();
                stateBid.setState(((BulkLocationTargetBidWithStringLocation)t).getLocation());
                BulkLocationTargetWithStringLocation.this.setStateBidAdditionialProperties(stateBid, t);
                return stateBid;
            }
        }, new Supplier<StateTarget>(){

            @Override
            public StateTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getStateTarget();
            }
        }, new Supplier<StateTarget>(){

            @Override
            public StateTarget get() {
                return new StateTarget();
            }
        }, new Consumer<StateTarget>(){

            @Override
            public void accept(StateTarget t) {
                BulkLocationTargetWithStringLocation.this.getLocation().setStateTarget(t);
            }
        }, new Supplier<List<StateTargetBid>>(){

            @Override
            public List<StateTargetBid> get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getStateTarget().getBids().getStateTargetBids();
            }
        }, new Consumer<List<StateTargetBid>>(){

            @Override
            public void accept(List<StateTargetBid> t) {
                BulkLocationTargetWithStringLocation.this.getLocation().getStateTarget().setBids(new ArrayOfStateTargetBid());
                BulkLocationTargetWithStringLocation.this.getLocation().getStateTarget().getBids().getStateTargetBids().addAll(t);
            }
        });
        this.reconstructApiBids(LocationTargetType.COUNTRY, new Function<TBid, CountryTargetBid>(){

            @Override
            public CountryTargetBid apply(TBid t) {
                CountryTargetBid countryBid = new CountryTargetBid();
                countryBid.setCountryAndRegion(((BulkLocationTargetBidWithStringLocation)t).getLocation());
                BulkLocationTargetWithStringLocation.this.setCountryBidAdditionialProperties(countryBid, t);
                return countryBid;
            }
        }, new Supplier<CountryTarget>(){

            @Override
            public CountryTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCountryTarget();
            }
        }, new Supplier<CountryTarget>(){

            @Override
            public CountryTarget get() {
                return new CountryTarget();
            }
        }, new Consumer<CountryTarget>(){

            @Override
            public void accept(CountryTarget t) {
                BulkLocationTargetWithStringLocation.this.getLocation().setCountryTarget(t);
            }
        }, new Supplier<List<CountryTargetBid>>(){

            @Override
            public List<CountryTargetBid> get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCountryTarget().getBids().getCountryTargetBids();
            }
        }, new Consumer<List<CountryTargetBid>>(){

            @Override
            public void accept(List<CountryTargetBid> t) {
                BulkLocationTargetWithStringLocation.this.getLocation().getCountryTarget().setBids(new ArrayOfCountryTargetBid());
                BulkLocationTargetWithStringLocation.this.getLocation().getCountryTarget().getBids().getCountryTargetBids().addAll(t);
            }
        });
    }

    abstract boolean shouldConvertPostalCodeTargetBid(PostalCodeTargetBid var1);

    abstract boolean shouldConvertCityTargetBid(CityTargetBid var1);

    abstract boolean shouldConvertMetroAreaTargetBid(MetroAreaTargetBid var1);

    abstract boolean shouldConvertStateTargetBid(StateTargetBid var1);

    abstract boolean shouldConvertCountryTargetBid(CountryTargetBid var1);

    abstract void setBulkPostalCodeBidAdditionalProperties(TBid var1, PostalCodeTargetBid var2);

    abstract void setBulkCityBidAdditionalProperties(TBid var1, CityTargetBid var2);

    abstract void setBulkMetroAreaBidAdditionalProperties(TBid var1, MetroAreaTargetBid var2);

    abstract void setBulkStateBidAdditionalProperties(TBid var1, StateTargetBid var2);

    abstract void setBulkCountryBidAdditionalProperties(TBid var1, CountryTargetBid var2);

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList bids = new ArrayList();
        this.convertBidsFromApi(LocationTargetType.POSTAL_CODE, bids, new Supplier<PostalCodeTarget>(){

            @Override
            public PostalCodeTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getPostalCodeTarget();
            }
        }, new Function<PostalCodeTarget, List<PostalCodeTargetBid>>(){

            @Override
            public List<PostalCodeTargetBid> apply(PostalCodeTarget t) {
                return t.getBids() != null ? t.getBids().getPostalCodeTargetBids() : null;
            }
        }, new Function<PostalCodeTargetBid, String>(){

            @Override
            public String apply(PostalCodeTargetBid t) {
                return t.getPostalCode();
            }
        }, new Function<PostalCodeTargetBid, Integer>(){

            @Override
            public Integer apply(PostalCodeTargetBid t) {
                return t.getBidAdjustment();
            }
        }, new Function<PostalCodeTargetBid, Boolean>(){

            @Override
            public Boolean apply(PostalCodeTargetBid t) {
                return BulkLocationTargetWithStringLocation.this.shouldConvertPostalCodeTargetBid(t);
            }
        });
        this.convertBidsFromApi(LocationTargetType.CITY, bids, new Supplier<CityTarget>(){

            @Override
            public CityTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCityTarget();
            }
        }, new Function<CityTarget, List<CityTargetBid>>(){

            @Override
            public List<CityTargetBid> apply(CityTarget t) {
                return t.getBids() != null ? t.getBids().getCityTargetBids() : null;
            }
        }, new Function<CityTargetBid, String>(){

            @Override
            public String apply(CityTargetBid t) {
                return t.getCity();
            }
        }, new Function<CityTargetBid, Integer>(){

            @Override
            public Integer apply(CityTargetBid t) {
                return t.getBidAdjustment();
            }
        }, new Function<CityTargetBid, Boolean>(){

            @Override
            public Boolean apply(CityTargetBid t) {
                return BulkLocationTargetWithStringLocation.this.shouldConvertCityTargetBid(t);
            }
        });
        this.convertBidsFromApi(LocationTargetType.METRO_AREA, bids, new Supplier<MetroAreaTarget>(){

            @Override
            public MetroAreaTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getMetroAreaTarget();
            }
        }, new Function<MetroAreaTarget, List<MetroAreaTargetBid>>(){

            @Override
            public List<MetroAreaTargetBid> apply(MetroAreaTarget t) {
                return t.getBids() != null ? t.getBids().getMetroAreaTargetBids() : null;
            }
        }, new Function<MetroAreaTargetBid, String>(){

            @Override
            public String apply(MetroAreaTargetBid t) {
                return t.getMetroArea();
            }
        }, new Function<MetroAreaTargetBid, Integer>(){

            @Override
            public Integer apply(MetroAreaTargetBid t) {
                return t.getBidAdjustment();
            }
        }, new Function<MetroAreaTargetBid, Boolean>(){

            @Override
            public Boolean apply(MetroAreaTargetBid t) {
                return BulkLocationTargetWithStringLocation.this.shouldConvertMetroAreaTargetBid(t);
            }
        });
        this.convertBidsFromApi(LocationTargetType.STATE, bids, new Supplier<StateTarget>(){

            @Override
            public StateTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getStateTarget();
            }
        }, new Function<StateTarget, List<StateTargetBid>>(){

            @Override
            public List<StateTargetBid> apply(StateTarget t) {
                return t.getBids() != null ? t.getBids().getStateTargetBids() : null;
            }
        }, new Function<StateTargetBid, String>(){

            @Override
            public String apply(StateTargetBid t) {
                return t.getState();
            }
        }, new Function<StateTargetBid, Integer>(){

            @Override
            public Integer apply(StateTargetBid t) {
                return t.getBidAdjustment();
            }
        }, new Function<StateTargetBid, Boolean>(){

            @Override
            public Boolean apply(StateTargetBid t) {
                return BulkLocationTargetWithStringLocation.this.shouldConvertStateTargetBid(t);
            }
        });
        this.convertBidsFromApi(LocationTargetType.COUNTRY, bids, new Supplier<CountryTarget>(){

            @Override
            public CountryTarget get() {
                return BulkLocationTargetWithStringLocation.this.getLocation().getCountryTarget();
            }
        }, new Function<CountryTarget, List<CountryTargetBid>>(){

            @Override
            public List<CountryTargetBid> apply(CountryTarget t) {
                return t.getBids() != null ? t.getBids().getCountryTargetBids() : null;
            }
        }, new Function<CountryTargetBid, String>(){

            @Override
            public String apply(CountryTargetBid t) {
                return t.getCountryAndRegion();
            }
        }, new Function<CountryTargetBid, Integer>(){

            @Override
            public Integer apply(CountryTargetBid t) {
                return t.getBidAdjustment();
            }
        }, new Function<CountryTargetBid, Boolean>(){

            @Override
            public Boolean apply(CountryTargetBid t) {
                return BulkLocationTargetWithStringLocation.this.shouldConvertCountryTargetBid(t);
            }
        });
        return bids;
    }

    @Override
    void validatePropertiesNotNull() {
        if (this.getCityTarget() == null && this.getMetroAreaTarget() == null && this.getStateTarget() == null && this.getCountryTarget() == null && this.getPostalCodeTarget() == null) {
            throw new IllegalStateException("At least one location sub target must be not null.");
        }
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getCityTarget() != null) {
            this.validateListNotNullOrEmpty(this.getCityTarget().getBids(), this.getCityTarget().getBids().getCityTargetBids(), "CityTarget.Bids");
        }
        if (this.getMetroAreaTarget() != null) {
            this.validateListNotNullOrEmpty(this.getMetroAreaTarget().getBids(), this.getMetroAreaTarget().getBids().getMetroAreaTargetBids(), "MetroAreaTarget.Bids");
        }
        if (this.getCountryTarget() != null) {
            this.validateListNotNullOrEmpty(this.getCountryTarget().getBids(), this.getCountryTarget().getBids().getCountryTargetBids(), "CountryTarget.Bids");
        }
        if (this.getStateTarget() != null) {
            this.validateListNotNullOrEmpty(this.getStateTarget().getBids(), this.getStateTarget().getBids().getStateTargetBids(), "StateTarget.Bids");
        }
        if (this.getPostalCodeTarget() != null) {
            this.validateListNotNullOrEmpty(this.getPostalCodeTarget().getBids(), this.getPostalCodeTarget().getBids().getPostalCodeTargetBids(), "PostalCodeTarget.Bids");
        }
    }

    protected <TApiBid, TTarget> void reconstructApiBids(LocationTargetType locationType, Function<TBid, TApiBid> createBid, Supplier<TTarget> getTarget, Supplier<TTarget> createNewTarget, Consumer<TTarget> setTarget, Supplier<List<TApiBid>> getBids, Consumer<List<TApiBid>> setBids) {
        ArrayList<BulkLocationTargetBidWithStringLocation> bulkBidsForLocationType = new ArrayList<BulkLocationTargetBidWithStringLocation>();
        for (BulkLocationTargetBidWithStringLocation bulkBid : this.getBids()) {
            if (bulkBid.getLocationType() != locationType) continue;
            bulkBidsForLocationType.add(bulkBid);
        }
        this.reconstructApiBids(bulkBidsForLocationType, createBid, getTarget, createNewTarget, setTarget, getBids, setBids);
    }

    protected <T, TTarget> void convertBidsFromApi(final LocationTargetType locationType, List<TBid> bids, Supplier<TTarget> getTarget, Function<TTarget, List<T>> getBids, final Function<T, String> getLocation, Function<T, Integer> getBidAdjustment, Function<T, Boolean> shouldConvertBid) {
        this.convertBidsFromApi(bids, getTarget, getBids, new BiConsumer<TBid, T>(){

            @Override
            public void accept(TBid bid, T rawBid) {
                ((BulkLocationTargetBidWithStringLocation)bid).setLocationType(locationType);
                ((BulkLocationTargetBidWithStringLocation)bid).setLocation((String)getLocation.apply(rawBid));
                if (rawBid instanceof CityTargetBid) {
                    BulkLocationTargetWithStringLocation.this.setBulkCityBidAdditionalProperties(bid, (CityTargetBid)rawBid);
                } else if (rawBid instanceof MetroAreaTargetBid) {
                    BulkLocationTargetWithStringLocation.this.setBulkMetroAreaBidAdditionalProperties(bid, (MetroAreaTargetBid)rawBid);
                } else if (rawBid instanceof StateTargetBid) {
                    BulkLocationTargetWithStringLocation.this.setBulkStateBidAdditionalProperties(bid, (StateTargetBid)rawBid);
                } else if (rawBid instanceof CountryTargetBid) {
                    BulkLocationTargetWithStringLocation.this.setBulkCountryBidAdditionalProperties(bid, (CountryTargetBid)rawBid);
                } else if (rawBid instanceof PostalCodeTargetBid) {
                    BulkLocationTargetWithStringLocation.this.setBulkPostalCodeBidAdditionalProperties(bid, (PostalCodeTargetBid)rawBid);
                } else {
                    throw new UnsupportedOperationException("unsupported bid type");
                }
            }
        }, shouldConvertBid);
    }
}

