/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkProductAdExtension;
import com.microsoft.bingads.bulk.entities.ProductConditionHelper;
import com.microsoft.bingads.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.campaignmanagement.ArrayOfProductCondition;
import com.microsoft.bingads.campaignmanagement.ProductConditionCollection;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.BulkProductAdExtensionIdentifier;
import com.microsoft.bingads.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkProductConditionCollection
extends SingleRecordBulkEntity {
    private ProductConditionCollection productConditionCollection;
    private BulkProductAdExtensionIdentifier identifier = new BulkProductAdExtensionIdentifier();
    private String name;
    private Long storeId;
    private String storeName;
    private static final List<BulkMapping<BulkProductConditionCollection>> MAPPINGS;

    public ProductConditionCollection getProductConditionCollection() {
        return this.productConditionCollection;
    }

    public void setProductConditionCollection(ProductConditionCollection productConditionCollection) {
        this.productConditionCollection = productConditionCollection;
    }

    BulkProductAdExtensionIdentifier getIdentifier() {
        return this.identifier;
    }

    void setIdentifier(BulkProductAdExtensionIdentifier identifier) {
        this.identifier = identifier;
    }

    public Long getAdExtensionId() {
        return this.identifier.getAdExtensionId();
    }

    public void setAdExtensionId(Long value) {
        this.identifier.setAdExtensionId(value);
    }

    public Long getAccountId() {
        return this.identifier.getAccountId();
    }

    public void setAccountId(Long value) {
        this.identifier.setAccountId(value);
    }

    public AdExtensionStatus getStatus() {
        return this.identifier.getStatus();
    }

    public void setStatus(AdExtensionStatus status) {
        this.identifier.setStatus(status);
    }

    public Integer getVersion() {
        return this.identifier.getVersion();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    private static void rowValuesToConditions(RowValues values, BulkProductConditionCollection c) {
        ProductConditionHelper.addConditionsFromRowValues(values, c.getProductConditionCollection().getConditions());
    }

    private static void conditionsToRowValues(BulkProductConditionCollection c, RowValues values) {
        ProductConditionHelper.addRowValuesFromConditions(c.getProductConditionCollection().getConditions(), values);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.productConditionCollection = new ProductConditionCollection();
        this.productConditionCollection.setConditions(new ArrayOfProductCondition());
        this.identifier.readFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values) {
        this.validatePropertyNotNull(this.getProductConditionCollection(), "ProductConditionCollection");
        this.validatePropertyNotNull(this.getProductConditionCollection().getConditions(), "ProductConditionCollection.Conditions");
        this.identifier.writeToRowValues(values);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public boolean canEncloseInMultilineEntity() {
        return true;
    }

    @Override
    public MultiRecordBulkEntity encloseInMultilineEntity() {
        return new BulkProductAdExtension(this);
    }

    static {
        ArrayList<BulkMapping<BulkProductConditionCollection>> m = new ArrayList<BulkMapping<BulkProductConditionCollection>>();
        m.add(new ComplexBulkMapping<BulkProductConditionCollection>(new BiConsumer<BulkProductConditionCollection, RowValues>(){

            @Override
            public void accept(BulkProductConditionCollection arg0, RowValues arg1) {
                BulkProductConditionCollection.conditionsToRowValues(arg0, arg1);
            }
        }, new BiConsumer<RowValues, BulkProductConditionCollection>(){

            @Override
            public void accept(RowValues arg0, BulkProductConditionCollection arg1) {
                BulkProductConditionCollection.rowValuesToConditions(arg0, arg1);
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductConditionCollection, String>("Name", new Function<BulkProductConditionCollection, String>(){

            @Override
            public String apply(BulkProductConditionCollection c) {
                return c.getName();
            }
        }, new BiConsumer<String, BulkProductConditionCollection>(){

            @Override
            public void accept(String v, BulkProductConditionCollection c) {
                c.setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductConditionCollection, Long>("Store Id", new Function<BulkProductConditionCollection, Long>(){

            @Override
            public Long apply(BulkProductConditionCollection c) {
                return c.getStoreId();
            }
        }, new BiConsumer<String, BulkProductConditionCollection>(){

            @Override
            public void accept(String v, BulkProductConditionCollection c) {
                c.setStoreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductConditionCollection, String>("Store Name", new Function<BulkProductConditionCollection, String>(){

            @Override
            public String apply(BulkProductConditionCollection c) {
                return c.getStoreName();
            }
        }, new BiConsumer<String, BulkProductConditionCollection>(){

            @Override
            public void accept(String v, BulkProductConditionCollection c) {
                c.setStoreName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

