/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk;

import com.microsoft.bingads.bulk.DownloadFileType;
import com.microsoft.bingads.bulk.entities.BulkEntity;
import com.microsoft.bingads.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.internal.bulk.SimpleBulkObjectWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class BulkFileWriter
implements Closeable {
    private BulkObjectWriter bulkObjectWriter;
    private boolean metadataWritten = false;

    public BulkFileWriter(File filePath) throws IOException {
        this(filePath, DownloadFileType.CSV);
    }

    public BulkFileWriter(File filePath, DownloadFileType fileFormat) throws IOException {
        this.bulkObjectWriter = new SimpleBulkObjectWriter(filePath, fileFormat);
    }

    public void writeEntity(BulkEntity entity) throws IOException {
        if (!this.metadataWritten) {
            this.bulkObjectWriter.writeFileMetadata();
            this.metadataWritten = true;
        }
        entity.writeToStream(this.bulkObjectWriter);
    }

    @Override
    public void close() throws IOException {
        this.bulkObjectWriter.close();
    }
}

