/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.reporting;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.v13.reporting.IReportingService;
import com.microsoft.bingads.v13.reporting.PollGenerateReportRequest;
import com.microsoft.bingads.v13.reporting.PollGenerateReportResponse;
import com.microsoft.bingads.v13.reporting.ReportRequestStatusType;
import com.microsoft.bingads.v13.reporting.ReportingOperationStatus;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;

public class ReportingStatusProvider {
    private final String requestId;
    private final AuthorizationData authorizationData;

    public ReportingStatusProvider(String requestId, AuthorizationData authorizationData) {
        this.requestId = requestId;
        this.authorizationData = authorizationData;
    }

    public Future<ReportingOperationStatus> getCurrentStatus(ServiceClient<IReportingService> serviceClient, AsyncCallback<ReportingOperationStatus> callback) {
        PollGenerateReportRequest request = new PollGenerateReportRequest();
        request.setReportRequestId(this.requestId);
        final ResultFuture<ReportingOperationStatus> resultFuture = new ResultFuture<ReportingOperationStatus>(callback);
        serviceClient.getService().pollGenerateReportAsync(request, new AsyncHandler<PollGenerateReportResponse>(){

            public void handleResponse(Response<PollGenerateReportResponse> result) {
                try {
                    PollGenerateReportResponse statusResponse = (PollGenerateReportResponse)result.get();
                    String trackingId = ServiceUtils.GetTrackingId(result);
                    ReportingOperationStatus status = new ReportingOperationStatus(ReportRequestStatusType.fromValue(statusResponse.getReportRequestStatus().getStatus().value()), statusResponse.getReportRequestStatus().getReportDownloadUrl(), trackingId);
                    resultFuture.setResult(status);
                }
                catch (InterruptedException e) {
                    resultFuture.setException(e);
                }
                catch (ExecutionException e) {
                    resultFuture.setException(e);
                }
            }
        });
        return resultFuture;
    }

    public boolean isFinalStatus(ReportingOperationStatus status) {
        if (status == null) {
            return false;
        }
        return status.getStatus() == ReportRequestStatusType.SUCCESS || status.getStatus() == ReportRequestStatusType.ERROR;
    }

    public boolean isSuccessStatus(ReportingOperationStatus status) {
        return status.getStatus() == ReportRequestStatusType.SUCCESS;
    }

    public boolean isResultFileUrl(ReportingOperationStatus status) {
        return status.getResultFileUrl() != null;
    }
}

