/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.EntityScope;
import com.microsoft.bingads.v13.campaignmanagement.SimilarRemarketingList;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSimilarRemarketingList
extends SingleRecordBulkEntity {
    private SimilarRemarketingList similarRemarketingList;
    private Status status;
    private static final List<BulkMapping<BulkSimilarRemarketingList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSimilarRemarketingList(new SimilarRemarketingList());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getSimilarRemarketingList(), SimilarRemarketingList.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public SimilarRemarketingList getSimilarRemarketingList() {
        return this.similarRemarketingList;
    }

    public void setSimilarRemarketingList(SimilarRemarketingList remarketingList) {
        this.similarRemarketingList = remarketingList;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSimilarRemarketingList, Object>> m = new ArrayList<SimpleBulkMapping<BulkSimilarRemarketingList, Object>>();
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, String>("Status", new Function<BulkSimilarRemarketingList, String>(){

            @Override
            public String apply(BulkSimilarRemarketingList c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Long>("Id", new Function<BulkSimilarRemarketingList, Long>(){

            @Override
            public Long apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getId();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Long>("Parent Id", new Function<BulkSimilarRemarketingList, Long>(){

            @Override
            public Long apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getParentId();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, String>("Audience", new Function<BulkSimilarRemarketingList, String>(){

            @Override
            public String apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getName();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Long>("Audience Search Size", new Function<BulkSimilarRemarketingList, Long>(){

            @Override
            public Long apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getSearchSize();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setSearchSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, String>("Description", new Function<BulkSimilarRemarketingList, String>(){

            @Override
            public String apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getDescription();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Integer>("Membership Duration", new Function<BulkSimilarRemarketingList, Integer>(){

            @Override
            public Integer apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getMembershipDuration();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, String>("Scope", new Function<BulkSimilarRemarketingList, String>(){

            @Override
            public String apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getScope() != null ? c.getSimilarRemarketingList().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Long>("Source Id", new Function<BulkSimilarRemarketingList, Long>(){

            @Override
            public Long apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getSourceId();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setSourceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, Long>("Audience Network Size", new Function<BulkSimilarRemarketingList, Long>(){

            @Override
            public Long apply(BulkSimilarRemarketingList c) {
                return c.getSimilarRemarketingList().getAudienceNetworkSize();
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setAudienceNetworkSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSimilarRemarketingList, String>("Supported Campaign Types", new Function<BulkSimilarRemarketingList, String>(){

            @Override
            public String apply(BulkSimilarRemarketingList c) {
                return StringExtensions.writeArrayOfstring(c.getSimilarRemarketingList().getSupportedCampaignTypes(), ";");
            }
        }, new BiConsumer<String, BulkSimilarRemarketingList>(){

            @Override
            public void accept(String v, BulkSimilarRemarketingList c) {
                c.getSimilarRemarketingList().setSupportedCampaignTypes(StringExtensions.parseArrayOfString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

