/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupAudienceAssociation
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String audienceName;
    private static final List<BulkMapping<BulkAdGroupAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        adGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        adGroupCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), "AdGroupAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.biddableAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Status", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, Long>("Id", new Function<BulkAdGroupAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, Long>("Parent Id", new Function<BulkAdGroupAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Campaign", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Ad Group", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Audience", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Bid Adjustment", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

