/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ActionAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ActionAdExtensionActionType;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkActionAdExtension
extends BulkAdExtension<ActionAdExtension> {
    private static final List<BulkMapping<BulkActionAdExtension>> MAPPINGS;
    private String actionText;

    public ActionAdExtension getActionAdExtension() {
        return (ActionAdExtension)this.getAdExtension();
    }

    public void setActionAdExtension(ActionAdExtension actionAdExtension) {
        this.setAdExtension(actionAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        ActionAdExtension extension = new ActionAdExtension();
        extension.setType("ActionAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getActionAdExtension(), "ActionAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public String getActionText() {
        return this.actionText;
    }

    public void setActionText(String actionText) {
        this.actionText = actionText;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkActionAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkActionAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Action Type", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension c) {
                return StringExtensions.toActionAdExtensionActionTypeBulkString(c.getActionAdExtension().getActionType());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                c.getActionAdExtension().setActionType(StringExtensions.parseOptional(v, new Function<String, ActionAdExtensionActionType>(){

                    @Override
                    public ActionAdExtensionActionType apply(String value) {
                        return ActionAdExtensionActionType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Final Url", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getActionAdExtension().getFinalUrls(), c.getActionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getActionAdExtension().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Mobile Final Url", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getActionAdExtension().getFinalMobileUrls(), c.getActionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getActionAdExtension().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Tracking Template", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension t) {
                return StringExtensions.toOptionalBulkString(t.getActionAdExtension().getTrackingUrlTemplate(), t.getActionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                c.getActionAdExtension().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Language", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension t) {
                return t.getActionAdExtension().getLanguage();
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                c.getActionAdExtension().setLanguage(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Custom Parameter", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension c) {
                return StringExtensions.toCustomParaBulkString(c.getActionAdExtension().getUrlCustomParameters(), c.getActionAdExtension().getId());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                try {
                    c.getActionAdExtension().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Action Text", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension t) {
                return t.getActionText();
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                c.setActionText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkActionAdExtension, String>("Final Url Suffix", new Function<BulkActionAdExtension, String>(){

            @Override
            public String apply(BulkActionAdExtension c) {
                return StringExtensions.toOptionalBulkString(((ActionAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((ActionAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkActionAdExtension>(){

            @Override
            public void accept(String v, BulkActionAdExtension c) {
                ((ActionAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

