/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.MessageHandlerBehavior;
import com.microsoft.bingads.internal.DefaultMessageHandlerBehaviorImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class MessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private static MessageHandler instance = new MessageHandler();
    private static MessageHandlerBehavior messageBehavior;
    private boolean traceOn = false;

    public void setTraceOn(boolean traceOn) {
        this.traceOn = traceOn;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    private MessageHandler() {
        messageBehavior = new DefaultMessageHandlerBehaviorImpl();
    }

    public static MessageHandler getInstance() {
        return instance;
    }

    public void setSoapMessageBehavior(MessageHandlerBehavior behavior) {
        messageBehavior = behavior;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (this.isTraceOn()) {
            try {
                Boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
                SOAPMessage msg = context.getMessage();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)out);
                String strMsg = new String(out.toByteArray());
                if (outbound.booleanValue()) {
                    messageBehavior.handleOutboundMessage(strMsg);
                } else {
                    messageBehavior.handleInboundMessage(strMsg);
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void handleDirectMessage(String message) {
        if (this.isTraceOn()) {
            messageBehavior.handleMessage(message);
        }
    }
}

