/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignLocationCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        LocationCriterion locationCriterion = new LocationCriterion();
        campaignCriterion.setCriterion(locationCriterion);
        campaignCriterion.getCriterion().setType(LocationCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignLocationCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignLocationCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Status", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, Long>("Id", new Function<BulkCampaignLocationCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, Long>("Parent Id", new Function<BulkCampaignLocationCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Campaign", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Bid Adjustment", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Target", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Sub Type", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationCriterion, String>("Name", new Function<BulkCampaignLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableCampaignCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

