/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.Experiment;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkExperiment
extends SingleRecordBulkEntity {
    private Experiment experiment;
    private static final List<BulkMapping<BulkExperiment>> MAPPINGS;

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setExperiment(new Experiment());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getExperiment(), "Experiment");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkExperiment, Object>> m = new ArrayList<SimpleBulkMapping<BulkExperiment, Object>>();
        m.add(new SimpleBulkMapping<BulkExperiment, Long>("Id", new Function<BulkExperiment, Long>(){

            @Override
            public Long apply(BulkExperiment t) {
                return t.getExperiment().getId();
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Status", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment t) {
                return StringExtensions.toOptionalBulkString(t.getExperiment().getExperimentStatus());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setExperimentStatus(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Name", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment t) {
                return t.getExperiment().getName();
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Traffic Split Percent", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment t) {
                return StringExtensions.toBulkString(t.getExperiment().getTrafficSplitPercent());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setTrafficSplitPercent(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Base Campaign Id", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment t) {
                return StringExtensions.toBulkString(t.getExperiment().getBaseCampaignId());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setBaseCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Experiment Campaign Id", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment t) {
                return StringExtensions.toBulkString(t.getExperiment().getExperimentCampaignId());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                c.getExperiment().setExperimentCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("Start Date", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment c) {
                return StringExtensions.toDateBulkString(c.getExperiment().getStartDate());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                try {
                    c.getExperiment().setStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkExperiment, String>("End Date", new Function<BulkExperiment, String>(){

            @Override
            public String apply(BulkExperiment c) {
                return StringExtensions.toDateBulkString(c.getExperiment().getEndDate());
            }
        }, new BiConsumer<String, BulkExperiment>(){

            @Override
            public void accept(String v, BulkExperiment c) {
                try {
                    c.getExperiment().setEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

