/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.IntentOption;
import com.microsoft.bingads.v12.campaignmanagement.LocationIntentCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignLocationIntentCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignLocationIntentCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        LocationIntentCriterion locationIntentCriterion = new LocationIntentCriterion();
        campaignCriterion.setCriterion(locationIntentCriterion);
        campaignCriterion.getCriterion().setType(LocationIntentCriterion.class.getSimpleName());
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Status", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Long>("Id", new Function<BulkCampaignLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationIntentCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Long>("Parent Id", new Function<BulkCampaignLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationIntentCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Campaign", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Target", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    IntentOption intentOption = ((LocationIntentCriterion)c.getBiddableCampaignCriterion().getCriterion()).getIntentOption();
                    return intentOption == null ? null : intentOption.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    ((LocationIntentCriterion)c.getBiddableCampaignCriterion().getCriterion()).setIntentOption(StringExtensions.parseOptional(v, new Function<String, IntentOption>(){

                        @Override
                        public IntentOption apply(String s) {
                            return IntentOption.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

