/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk;

import com.microsoft.bingads.v12.bulk.OperationError;
import com.microsoft.bingads.v12.bulk.UploadStatus;
import java.util.List;

public class BulkUploadCouldNotBeCompletedException
extends RuntimeException {
    private final List<OperationError> errors;
    private final UploadStatus status;

    public BulkUploadCouldNotBeCompletedException(List<OperationError> errors, UploadStatus status) {
        this.errors = errors;
        this.status = status;
    }

    public BulkUploadCouldNotBeCompletedException(List<OperationError> errors, UploadStatus status, String message) {
        super(message);
        this.errors = errors;
        this.status = status;
    }

    public List<OperationError> getErrors() {
        return this.errors;
    }

    public UploadStatus getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        StringBuilder errorsInfo = new StringBuilder();
        for (OperationError error : this.errors) {
            errorsInfo.append(String.format("code=%d, details=%s, errorCode=%s, message=%s; ", error.getCode(), error.getDetails(), error.getErrorCode(), error.getMessage()));
        }
        return String.format("%s Upload status is %s, errors are %s", new Object[]{super.toString(), this.status, errorsInfo});
    }
}

